/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect;

import htsjdk.variant.variantcontext.Allele;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.broadinstitute.hellbender.utils.Utils;

public class PerAlleleCollection<X extends Number> {
    private Optional<Allele> refAllele;
    private Optional<X> refValue;
    private Map<Allele, X> altAlleleValueMap;
    private Type type;

    public PerAlleleCollection(Type type) {
        this.type = type;
        this.altAlleleValueMap = new HashMap<Allele, X>();
        this.refAllele = Optional.empty();
    }

    public void set(Allele allele, X value) {
        Utils.nonNull(allele, "allele is null");
        Utils.nonNull(value, "value is null");
        Utils.validateArg(this.type == Type.REF_AND_ALT || allele.isNonReference(), "Collection stores values for alternate alleles only");
        if (allele.isReference()) {
            this.setRef(allele, value);
        } else {
            this.setAlt(allele, value);
        }
    }

    public void set(Collection<Allele> alleles, Function<Allele, X> function) {
        alleles.forEach(a -> this.set((Allele)a, (X)((Number)function.apply((Allele)a))));
    }

    public void setRef(Allele allele, X value) {
        Utils.nonNull(allele, "ref allele is null");
        Utils.nonNull(value, "value is null");
        Utils.validateArg(allele.isReference(), "setting non-reference allele as reference");
        Utils.validateArg(!this.refAllele.isPresent(), "Resetting the reference allele not permitted");
        this.refAllele = Optional.of(allele);
        this.refValue = Optional.of(value);
    }

    public void setAlt(Allele allele, X value) {
        Utils.nonNull(allele, "ref allele is null");
        Utils.nonNull(value, "value is null");
        Utils.validateArg(allele.isNonReference(), "Setting reference allele as alt");
        this.altAlleleValueMap.put(allele, value);
    }

    public X get(Allele allele) {
        Utils.nonNull(allele, "allele is null");
        if (allele.isReference()) {
            Utils.validateArg(allele.equals((Object)this.refAllele.get()), "Requested ref allele does not match the stored ref allele");
            return this.getRef();
        }
        return this.getAlt(allele);
    }

    public X getRef() {
        if (this.type == Type.ALT_ONLY) {
            throw new IllegalStateException("Collection does not hold the REF allele");
        }
        if (this.refAllele.isPresent()) {
            return (X)((Number)this.refValue.get());
        }
        throw new IllegalStateException("Collection's ref allele has not been set yet");
    }

    public X getAlt(Allele allele) {
        Utils.nonNull(allele, "allele is null");
        Utils.validateArg(allele.isNonReference(), "allele is not an alt allele");
        Utils.validateArg(this.altAlleleValueMap.containsKey(allele), "Requested alt allele is not in the collection");
        return (X)((Number)this.altAlleleValueMap.get(allele));
    }

    public double[] asDoubleArray(Collection<Allele> allelesInOrder) {
        return allelesInOrder.stream().mapToDouble(a -> ((Number)this.get((Allele)a)).doubleValue()).toArray();
    }

    public Set<Allele> getAltAlleles() {
        return this.altAlleleValueMap.keySet();
    }

    public Allele getRefAllele() {
        Utils.validateArg(this.refAllele.isPresent(), "no ref allele");
        return this.refAllele.get();
    }

    public static enum Type {
        ALT_ONLY,
        REF_AND_ALT;

    }
}

