/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceModel;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceResult;
import org.broadinstitute.hellbender.tools.walkers.mutect.Mutect2Engine;
import org.broadinstitute.hellbender.tools.walkers.mutect.PerAlleleCollection;
import org.broadinstitute.hellbender.tools.walkers.mutect.SomaticRefVsAnyResult;
import org.broadinstitute.hellbender.tools.walkers.readorientation.BetaDistributionShape;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class SomaticReferenceConfidenceModel
extends ReferenceConfidenceModel {
    private final SampleList samples;
    private final Optional<BetaDistributionShape> afPrior;

    SomaticReferenceConfidenceModel(SampleList samples, SAMFileHeader header, int indelInformativeDepthIndelSize, double minAF) {
        super(samples, header, indelInformativeDepthIndelSize, 0);
        Utils.validateArg(minAF >= 0.0 && minAF < 1.0, "minAF must be < 1 and >= 0");
        this.afPrior = minAF == 0.0 ? Optional.empty() : Optional.of(new BetaDistributionShape(1.0 - Math.log(2.0) / Math.log(minAF), 1.0));
        this.samples = samples;
    }

    @Override
    public ReferenceConfidenceResult calcGenotypeLikelihoodsOfRefVsAny(int ploidy, ReadPileup pileup, byte refBase, byte minBaseQual, MathUtils.RunningAverage hqSoftClips, boolean readsWereRealigned) {
        SomaticRefVsAnyResult result = new SomaticRefVsAnyResult();
        HashMap<String, List<GATKRead>> perSampleReadMap = new HashMap<String, List<GATKRead>>();
        perSampleReadMap.put(this.samples.getSample(0), pileup.getReads());
        ArrayList<Byte> altQuals = new ArrayList<Byte>(pileup.size() / 20);
        for (PileupElement element : pileup) {
            boolean isAlt;
            if (!element.isDeletion() && element.getQual() <= minBaseQual) continue;
            boolean bl = isAlt = readsWereRealigned ? SomaticReferenceConfidenceModel.isAltAfterAssembly(element, refBase) : SomaticReferenceConfidenceModel.isAltBeforeAssembly(element, refBase);
            if (isAlt) {
                altQuals.add(element.getQual());
                ++result.nonRefDepth;
                continue;
            }
            ++result.refDepth;
        }
        double logOdds = Mutect2Engine.logLikelihoodRatio(result.refDepth, altQuals, 1, this.afPrior);
        result.lods = new PerAlleleCollection(PerAlleleCollection.Type.ALT_ONLY);
        result.lods.set(Allele.NON_REF_ALLELE, logOdds);
        return result;
    }

    @Override
    public void addGenotypeData(ReferenceConfidenceResult result, GenotypeBuilder gb) {
        gb.attribute("TLOD", (Object)MathUtils.logToLog10(((SomaticRefVsAnyResult)result).lods.get(Allele.NON_REF_ALLELE)));
    }

    @Override
    public void doIndelRefConfCalc(int ploidy, byte[] ref, ReadPileup pileup, int refOffset, ReferenceConfidenceResult homRefCalc) {
    }
}

