/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect;

import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.utils.IndexRange;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.LikelihoodMatrix;

public class SubsettedLikelihoodMatrix<EVIDENCE extends Locatable, A extends Allele>
implements LikelihoodMatrix<EVIDENCE, A> {
    private final LikelihoodMatrix<EVIDENCE, A> matrix;
    private final List<A> alleles;
    private final Int2IntMap newToOldIndexMap;

    public SubsettedLikelihoodMatrix(LikelihoodMatrix<EVIDENCE, A> matrix, List<A> alleles) {
        this.matrix = Utils.nonNull(matrix);
        this.alleles = Utils.nonNull(alleles);
        int[] newIndices = new IndexRange(0, alleles.size()).mapToInteger(n -> n);
        int[] oldIndices = alleles.stream().mapToInt(matrix::indexOfAllele).toArray();
        Utils.validateArg(Arrays.stream(oldIndices).noneMatch(n -> n < 0), "All alleles must be found in likelihoods matrix");
        this.newToOldIndexMap = new Int2IntArrayMap(newIndices, oldIndices);
    }

    public static <EVIDENCE extends Locatable, A extends Allele> SubsettedLikelihoodMatrix<EVIDENCE, A> excludingAllele(LikelihoodMatrix<EVIDENCE, A> matrix, Allele excludedAllele) {
        List alleles = matrix.alleles().stream().filter(a -> !SubsettedLikelihoodMatrix.basesMatch(a, excludedAllele)).collect(Collectors.toList());
        Utils.validateArg(alleles.size() == matrix.numberOfAlleles() - 1, "More than one allele excluded.");
        return new SubsettedLikelihoodMatrix<EVIDENCE, A>(matrix, alleles);
    }

    public static boolean basesMatch(Allele a, Allele b) {
        return a.getBases() == b.getBases() || Arrays.equals(a.getBases(), b.getBases());
    }

    @Override
    public List<EVIDENCE> evidence() {
        return this.matrix.evidence();
    }

    @Override
    public List<A> alleles() {
        return this.alleles;
    }

    @Override
    public void set(int alleleIndex, int evidenceIndex, double value) {
        throw new UnsupportedOperationException("Subsetted likelihood matrices are immutable.");
    }

    @Override
    public double get(int alleleIndex, int evidenceIndex) {
        return this.matrix.get(this.newToOldIndexMap.get(alleleIndex), evidenceIndex);
    }

    @Override
    public int indexOfAllele(A allele) {
        return this.alleles.indexOf(allele);
    }

    @Override
    public int indexOfEvidence(EVIDENCE evidence) {
        return this.matrix.indexOfEvidence(evidence);
    }

    @Override
    public int numberOfAlleles() {
        return this.alleles.size();
    }

    @Override
    public int evidenceCount() {
        return this.matrix.evidenceCount();
    }

    @Override
    public A getAllele(int alleleIndex) {
        return (A)((Allele)this.alleles.get(alleleIndex));
    }

    @Override
    public EVIDENCE getEvidence(int evidenceIndex) {
        return (EVIDENCE)((Locatable)this.matrix.getEvidence(evidenceIndex));
    }

    @Override
    public void copyAlleleLikelihoods(int alleleIndex, double[] dest, int offset) {
        throw new UnsupportedOperationException("Subsetted likelihood matrices are not meant to be copied.");
    }
}

