/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.clustering;

import java.util.List;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.tools.walkers.mutect.clustering.AlleleFractionCluster;
import org.broadinstitute.hellbender.tools.walkers.mutect.clustering.BetaBinomialCluster;
import org.broadinstitute.hellbender.tools.walkers.mutect.clustering.Datum;
import org.broadinstitute.hellbender.tools.walkers.readorientation.BetaDistributionShape;
import org.broadinstitute.hellbender.tools.walkers.validation.basicshortmutpileup.BetaBinomialDistribution;
import org.broadinstitute.hellbender.utils.MathUtils;

public class BinomialCluster
implements AlleleFractionCluster {
    private static final double STD_DEV_OVER_MEAN = 0.01;
    private BetaDistributionShape betaDistributionShape;

    public BinomialCluster(double mean) {
        this.betaDistributionShape = BinomialCluster.getFuzzyBinomial(mean);
    }

    @Override
    public double correctedLogLikelihood(Datum datum) {
        return BetaBinomialCluster.correctedLogLikelihood(datum, this.betaDistributionShape);
    }

    @Override
    public double logLikelihood(int totalCount, int altCount) {
        return new BetaBinomialDistribution(null, this.betaDistributionShape.getAlpha(), this.betaDistributionShape.getBeta(), totalCount).logProbability(altCount);
    }

    @Override
    public void learn(List<Datum> data, double[] responsibilities) {
        double altCount = IntStream.range(0, data.size()).mapToDouble(n -> (double)((Datum)data.get(n)).getAltCount() * responsibilities[n]).sum() + 1.0E-4;
        double totalCount = IntStream.range(0, data.size()).mapToDouble(n -> (double)((Datum)data.get(n)).getTotalCount() * responsibilities[n]).sum() + 1.0E-4;
        this.betaDistributionShape = BinomialCluster.getFuzzyBinomial(altCount / totalCount);
    }

    private static BetaDistributionShape getFuzzyBinomial(double unboundedMean) {
        double mean = Math.min(unboundedMean, 0.99);
        double alphaPlusBeta = (1.0 - mean) / (mean * MathUtils.square(0.01)) - 1.0;
        double alpha = mean * alphaPlusBeta;
        double beta = alphaPlusBeta - alpha;
        return new BetaDistributionShape(alpha, beta);
    }

    @Override
    public String toString() {
        return String.format("mean = %.3f", this.betaDistributionShape.getAlpha() / (this.betaDistributionShape.getAlpha() + this.betaDistributionShape.getBeta()));
    }
}

