/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.clustering;

public class Datum {
    private final double tumorLogOdds;
    private final double artifactProb;
    private final double nonSequencingErrorProb;
    private final int altCount;
    private final int totalCount;
    private final int indelLength;

    public Datum(double tumorLogOdds, double artifactProb, double nonSomaticProb, int altCount, int totalCount, int indelLength) {
        this.tumorLogOdds = tumorLogOdds;
        this.artifactProb = artifactProb;
        this.altCount = altCount;
        this.totalCount = totalCount;
        this.indelLength = indelLength;
        this.nonSequencingErrorProb = 1.0 - (1.0 - artifactProb) * (1.0 - nonSomaticProb);
    }

    public double getTumorLogOdds() {
        return this.tumorLogOdds;
    }

    public double getArtifactProb() {
        return this.artifactProb;
    }

    public double getNonSequencingErrorProb() {
        return this.nonSequencingErrorProb;
    }

    public int getAltCount() {
        return this.altCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getIndelLength() {
        return this.indelLength;
    }
}

