/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.walkers.annotator.AnnotationUtils;
import org.broadinstitute.hellbender.utils.Utils;

public class AlleleFilterUtils {
    public static List<List<String>> decodeASFilters(VariantContext vc) {
        return AnnotationUtils.decodeAnyASListWithRawDelim(vc.getCommonInfo().getAttributeAsString("AS_FilterStatus", "")).stream().map(filters -> AnnotationUtils.decodeAnyASList(filters).stream().map(String::trim).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public static String encodeASFilters(List<List<String>> filters) {
        return AnnotationUtils.encodeAnyASListWithRawDelim(filters.stream().map(alleleFilters -> AnnotationUtils.encodeStringList(alleleFilters)).collect(Collectors.toList()));
    }

    public static String getMergedASFilterString(VariantContext vc, List<Boolean> isFiltered, String filterName) {
        List<List<String>> alleleFilters = AlleleFilterUtils.decodeASFilters(vc);
        Utils.validateArg(isFiltered.size() == alleleFilters.size(), "lists are not the same size");
        ListIterator<Boolean> isFilteredIt = isFiltered.listIterator();
        List<List<String>> updatedFilters = alleleFilters.stream().map(filters -> {
            Boolean filtered = (Boolean)isFilteredIt.next();
            if (filtered.booleanValue()) {
                return AlleleFilterUtils.addAlleleFilters(filters, Collections.singletonList(filterName));
            }
            return filters;
        }).collect(Collectors.toList());
        return AlleleFilterUtils.encodeASFilters(updatedFilters);
    }

    protected static List<String> addAlleleFilters(List<String> currentAlleleFilters, List<String> newFilters) {
        if (newFilters.isEmpty()) {
            return currentAlleleFilters;
        }
        if (currentAlleleFilters.isEmpty() || currentAlleleFilters.size() == 1 && currentAlleleFilters.contains("SITE")) {
            return newFilters;
        }
        LinkedHashSet<String> updated = new LinkedHashSet<String>();
        updated.addAll(currentAlleleFilters);
        updated.addAll(newFilters);
        return updated.stream().collect(Collectors.toList());
    }

    public static VariantContext addAlleleAndSiteFilters(VariantContext vc, List<Set<String>> newAlleleFilters, boolean invalidatePreviousFilters) {
        if (newAlleleFilters.isEmpty()) {
            return vc;
        }
        List<List<String>> currentAlleleFilters = AlleleFilterUtils.decodeASFilters(vc);
        if (!currentAlleleFilters.isEmpty() && newAlleleFilters.size() != currentAlleleFilters.size()) {
            return vc;
        }
        if (currentAlleleFilters.isEmpty() || invalidatePreviousFilters) {
            currentAlleleFilters = new ArrayList<List<String>>(Collections.nCopies(newAlleleFilters.size(), Collections.singletonList("SITE")));
        }
        ListIterator<List<String>> currentAlleleFiltersIt = currentAlleleFilters.listIterator();
        List<List<String>> updatedAlleleFilters = newAlleleFilters.stream().map(newfilters -> AlleleFilterUtils.addAlleleFilters((List)currentAlleleFiltersIt.next(), newfilters.stream().collect(Collectors.toList()))).collect(Collectors.toList());
        String encodedFilters = AlleleFilterUtils.encodeASFilters(updatedAlleleFilters);
        VariantContextBuilder vcb = new VariantContextBuilder(vc).attribute("AS_FilterStatus", (Object)encodedFilters);
        if (invalidatePreviousFilters) {
            vcb.unfiltered();
        }
        Set siteFiltersToAdd = newAlleleFilters.stream().skip(1L).collect(() -> new HashSet((Collection)newAlleleFilters.get(0)), Set::retainAll, Set::retainAll);
        siteFiltersToAdd.stream().forEach(filter -> vcb.filter(filter));
        if ((vcb.getFilters() == null || vcb.getFilters().isEmpty()) && !invalidatePreviousFilters) {
            vcb.passFilters();
        }
        return vcb.make();
    }
}

