/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.HardAlleleFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;

public class BaseQualityFilter
extends HardAlleleFilter {
    private final double minMedianBaseQuality;

    public BaseQualityFilter(double minMedianBaseQuality) {
        this.minMedianBaseQuality = minMedianBaseQuality;
    }

    @Override
    public ErrorType errorType() {
        return ErrorType.ARTIFACT;
    }

    @Override
    public List<Boolean> areAllelesArtifacts(VariantContext vc, Mutect2FilteringEngine filteringEngine, ReferenceContext referenceContext) {
        return vc.getAttributeAsIntList("MBQ", 0).stream().skip(1L).map(qual -> (double)qual.intValue() < this.minMedianBaseQuality).collect(Collectors.toList());
    }

    @Override
    public String filterName() {
        return "base_qual";
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Collections.singletonList("MBQ");
    }
}

