/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.HardFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;

public class ClusteredEventsFilter
extends HardFilter {
    private final int maxEventsInRegion;

    public ClusteredEventsFilter(int maxEventsInRegion) {
        this.maxEventsInRegion = maxEventsInRegion;
    }

    @Override
    public ErrorType errorType() {
        return ErrorType.ARTIFACT;
    }

    @Override
    public boolean isArtifact(VariantContext vc, Mutect2FilteringEngine filteringEngine) {
        Integer eventCount = vc.getAttributeAsInt("ECNT", -1);
        return eventCount > this.maxEventsInRegion;
    }

    @Override
    public String filterName() {
        return "clustered_events";
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Collections.singletonList("ECNT");
    }
}

