/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.contamination.ContaminationRecord;
import org.broadinstitute.hellbender.tools.walkers.mutect.clustering.SomaticClusteringModel;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2AlleleFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;
import org.broadinstitute.hellbender.utils.IndexRange;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.variant.VariantContextGetters;

public class ContaminationFilter
extends Mutect2AlleleFilter {
    private final Map<String, Double> contaminationBySample;
    private final double defaultContamination;
    private final double EPSILON = 1.0E-10;

    public ContaminationFilter(List<File> contaminationTables, double contaminationEstimate) {
        this.contaminationBySample = contaminationTables.stream().map(file -> ContaminationRecord.readFromFile(file).get(0)).collect(Collectors.toMap(rec -> rec.getSample(), rec -> rec.getContamination()));
        this.defaultContamination = contaminationEstimate;
    }

    @Override
    public ErrorType errorType() {
        return ErrorType.NON_SOMATIC;
    }

    @Override
    public List<Double> calculateErrorProbabilityForAlleles(VariantContext vc, Mutect2FilteringEngine filteringEngine, ReferenceContext referenceContext) {
        ArrayList depthsAndPosteriorsPerAllele = new ArrayList();
        new IndexRange(0, vc.getNAlleles() - 1).forEach(i -> depthsAndPosteriorsPerAllele.add(new ArrayList()));
        for (Genotype tumorGenotype : vc.getGenotypes()) {
            if (filteringEngine.isNormal(tumorGenotype)) continue;
            double contaminationFromFile = this.contaminationBySample.getOrDefault(tumorGenotype.getSampleName(), this.defaultContamination);
            double contamination = Math.max(0.0, Math.min(contaminationFromFile, 0.9999999999));
            int[] ADs = tumorGenotype.getAD();
            int totalAD = (int)MathUtils.sum(ADs);
            int[] altADs = Arrays.copyOfRange(ADs, 1, ADs.length);
            double[] negativeLog10AlleleFrequencies = VariantContextGetters.getAttributeAsDoubleArray(vc, "POPAF", () -> new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY}, Double.POSITIVE_INFINITY);
            double[] alleleFrequencies = MathUtils.applyToArray(negativeLog10AlleleFrequencies, x -> Math.pow(10.0, -x));
            SomaticClusteringModel model = filteringEngine.getSomaticClusteringModel();
            double[] logSomaticLikelihoodPerAllele = Arrays.stream(altADs).mapToDouble(altCount -> model.logLikelihoodGivenSomatic(totalAD, altCount)).toArray();
            double[] singleContaminantLikelihoodPerAllele = new double[alleleFrequencies.length];
            double[] manyContaminantLikelihoodPerAllele = new double[alleleFrequencies.length];
            double[] logContaminantLikelihoodPerAllele = new double[alleleFrequencies.length];
            double[] logOddsOfRealVsContaminationPerAllele = new double[alleleFrequencies.length];
            double[] posteriorProbOfContaminationPerAllele = new double[alleleFrequencies.length];
            new IndexRange(0, alleleFrequencies.length).forEach(i -> {
                singleContaminantLikelihoodPerAllele[i] = 2.0 * alleleFrequencies[i] * (1.0 - alleleFrequencies[i]) * MathUtils.binomialProbability(totalAD, altADs[i], contamination / 2.0) + MathUtils.square(alleleFrequencies[i]) * MathUtils.binomialProbability(totalAD, altADs[i], contamination);
                manyContaminantLikelihoodPerAllele[i] = MathUtils.binomialProbability(totalAD, altADs[i], contamination * alleleFrequencies[i]);
                logContaminantLikelihoodPerAllele[i] = Math.log(Math.max(singleContaminantLikelihoodPerAllele[i], manyContaminantLikelihoodPerAllele[i]));
                logOddsOfRealVsContaminationPerAllele[i] = logSomaticLikelihoodPerAllele[i] - logContaminantLikelihoodPerAllele[i];
            });
            new IndexRange(0, alleleFrequencies.length).forEach(i -> {
                posteriorProbOfContaminationPerAllele[i] = filteringEngine.posteriorProbabilityOfError(vc, logOddsOfRealVsContaminationPerAllele[i], i);
                ((List)depthsAndPosteriorsPerAllele.get(i)).add(ImmutablePair.of((Object)altADs[i], (Object)posteriorProbOfContaminationPerAllele[i]));
            });
        }
        return depthsAndPosteriorsPerAllele.stream().map(alleleData -> alleleData.isEmpty() ? Double.NaN : ContaminationFilter.weightedMedianPosteriorProbability(alleleData)).collect(Collectors.toList());
    }

    @Override
    public String filterName() {
        return "contamination";
    }

    @Override
    public Optional<String> phredScaledPosteriorAnnotationName() {
        return Optional.of("CONTQ");
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Collections.singletonList("POPAF");
    }
}

