/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.HardAlleleFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;

public class DuplicatedAltReadFilter
extends HardAlleleFilter {
    private final int uniqueAltReadCount;

    public DuplicatedAltReadFilter(int uniqueAltReadCount) {
        this.uniqueAltReadCount = uniqueAltReadCount;
    }

    @Override
    public ErrorType errorType() {
        return ErrorType.ARTIFACT;
    }

    @Override
    public List<Boolean> areAllelesArtifacts(VariantContext vc, Mutect2FilteringEngine filteringEngine, ReferenceContext referenceContext) {
        return vc.getAttributeAsIntList("AS_UNIQ_ALT_READ_COUNT", 1).stream().map(count -> count <= this.uniqueAltReadCount).collect(Collectors.toList());
    }

    @Override
    public String filterName() {
        return "duplicate";
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Collections.singletonList("AS_UNIQ_ALT_READ_COUNT");
    }
}

