/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2Filter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2VariantFilter;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public final class ErrorProbabilities {
    private LinkedHashMap<Mutect2Filter, List<Double>> alleleProbabilitiesByFilter;
    private final Map<ErrorType, List<Double>> probabilitiesByTypeAndAllele;
    private final List<Double> combinedErrorProbabilitiesByAllele;
    private final int numAltAlleles;

    public ErrorProbabilities(List<Mutect2Filter> filters, VariantContext vc, Mutect2FilteringEngine filteringEngine, ReferenceContext referenceContext) {
        this.numAltAlleles = vc.getAlternateAlleles().size();
        this.alleleProbabilitiesByFilter = filters.stream().collect(Collectors.toMap(Function.identity(), f -> f.errorProbabilities(vc, filteringEngine, referenceContext), (a, b) -> a, LinkedHashMap::new)).entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
        this.alleleProbabilitiesByFilter.replaceAll((k, v) -> GATKVariantContextUtils.removeDataForSymbolicAltAlleles(vc, v));
        LinkedHashMap probabilitiesByAllelesForEachFilter = this.alleleProbabilitiesByFilter.entrySet().stream().collect(Collectors.groupingBy(entry -> ((Mutect2Filter)entry.getKey()).errorType(), LinkedHashMap::new, Collectors.mapping(entry -> (List)entry.getValue(), Collectors.toList())));
        probabilitiesByAllelesForEachFilter.replaceAll((k, v) -> ErrorProbabilities.transpose(v));
        this.probabilitiesByTypeAndAllele = probabilitiesByAllelesForEachFilter.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(alleleList -> alleleList.stream().max(Double::compare).orElse(0.0)).collect(Collectors.toList()), (a, b) -> a, HashMap::new));
        this.combinedErrorProbabilitiesByAllele = ErrorProbabilities.transpose(this.probabilitiesByTypeAndAllele.values().stream().collect(Collectors.toList())).stream().map(alleleProbabilities -> alleleProbabilities.stream().map(p -> 1.0 - p).reduce(1.0, (a, b) -> a * b)).collect(Collectors.toList());
        this.combinedErrorProbabilitiesByAllele.replaceAll(trueProb -> Mutect2FilteringEngine.roundFinitePrecisionErrors(1.0 - trueProb));
    }

    public List<Double> getCombinedErrorProbabilities() {
        return this.combinedErrorProbabilitiesByAllele;
    }

    public List<Double> getTechnicalArtifactProbabilities() {
        return this.probabilitiesByTypeAndAllele.get((Object)ErrorType.ARTIFACT);
    }

    public List<Double> getNonSomaticProbabilities() {
        return this.probabilitiesByTypeAndAllele.get((Object)ErrorType.NON_SOMATIC);
    }

    public Map<Mutect2Filter, List<Double>> getProbabilitiesByFilter() {
        return this.alleleProbabilitiesByFilter;
    }

    public LinkedHashMap<Mutect2Filter, List<Double>> getProbabilitiesForAlleleFilters() {
        return this.getPartitionedProbabilitiesByFilter(false);
    }

    public LinkedHashMap<Mutect2Filter, Double> getProbabilitiesForVariantFilters() {
        return this.getPartitionedProbabilitiesByFilter(true).entrySet().stream().filter(entry -> entry.getValue() != null && !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(entry -> (Mutect2Filter)entry.getKey(), entry -> (Double)((List)entry.getValue()).get(0), (a, b) -> b, LinkedHashMap::new));
    }

    private LinkedHashMap<Mutect2Filter, List<Double>> getPartitionedProbabilitiesByFilter(boolean variantOnly) {
        Map<Boolean, LinkedHashMap> groups = this.alleleProbabilitiesByFilter.entrySet().stream().collect(Collectors.partitioningBy(entry -> Mutect2VariantFilter.class.isAssignableFrom(((Mutect2Filter)entry.getKey()).getClass()), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new)));
        return groups.get(variantOnly);
    }

    public static <T> List<List<T>> transpose(List<List<T>> list) {
        if (list.isEmpty()) {
            return list;
        }
        Utils.validateArg(list.stream().map(List::size).distinct().count() == 1L, "lists are not the same size");
        List iterList = list.stream().map(it -> it.iterator()).collect(Collectors.toList());
        return IntStream.range(0, list.get(0).size()).mapToObj(n -> iterList.stream().filter(it -> it.hasNext()).map(m -> m.next()).collect(Collectors.toList())).collect(Collectors.toList());
    }
}

