/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.io.File;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.MultiplePassVariantWalker;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.M2FiltersArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.variant.GATKVCFConstants;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import picard.cmdline.programgroups.VariantFilteringProgramGroup;

@CommandLineProgramProperties(summary="Filter somatic SNVs and indels called by Mutect2", oneLineSummary="Filter somatic SNVs and indels called by Mutect2", programGroup=VariantFilteringProgramGroup.class)
@DocumentedFeature
public final class FilterMutectCalls
extends MultiplePassVariantWalker {
    public static final String FILTERING_STATS_LONG_NAME = "filtering-stats";
    public static final String FILTERING_STATUS_VCF_KEY = "filtering_status";
    public static final String FILTERING_STATS_EXTENSION = ".filteringStats.tsv";
    @Argument(fullName="output", shortName="O", doc="The output filtered VCF file", optional=false)
    private final String outputVcf;
    @Argument(fullName="stats", doc="The Mutect stats file output by Mutect2", optional=true)
    private final String statsTable;
    @Argument(fullName="filtering-stats", doc="The output filtering stats file", optional=true)
    private final String filteringStatsOutput;
    @ArgumentCollection
    protected M2FiltersArgumentCollection MTFAC = new M2FiltersArgumentCollection();
    private VariantContextWriter vcfWriter;
    private Mutect2FilteringEngine filteringEngine;
    private static final int NUMBER_OF_LEARNING_PASSES = 2;

    public FilterMutectCalls() {
        this.outputVcf = null;
        this.statsTable = null;
        this.filteringStatsOutput = null;
    }

    @Override
    protected int numberOfPasses() {
        return 4;
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public void onTraversalStart() {
        Utils.resetRandomGenerator();
        VCFHeader inputHeader = this.getHeaderForVariants();
        Set headerLines = inputHeader.getMetaDataInSortedOrder().stream().filter(line -> !line.getKey().equals(FILTERING_STATUS_VCF_KEY)).collect(Collectors.toSet());
        headerLines.add(new VCFHeaderLine(FILTERING_STATUS_VCF_KEY, "These calls have been filtered by " + FilterMutectCalls.class.getSimpleName() + " to label false positives with a list of failed filters and true positives with PASS."));
        GATKVCFConstants.MUTECT_FILTER_NAMES.stream().map(GATKVCFHeaderLines::getFilterLine).forEach(headerLines::add);
        GATKVCFConstants.MUTECT_AS_FILTER_NAMES.stream().map(GATKVCFHeaderLines::getInfoLine).forEach(headerLines::add);
        headerLines.addAll(this.getDefaultToolVCFHeaderLines());
        VCFHeader vcfHeader = new VCFHeader(headerLines, inputHeader.getGenotypeSamples());
        this.vcfWriter = this.createVCFWriter(new File(this.outputVcf));
        this.vcfWriter.writeHeader(vcfHeader);
        File mutect2StatsTable = new File(this.statsTable == null ? this.drivingVariantFile + ".stats" : this.statsTable);
        this.filteringEngine = new Mutect2FilteringEngine(this.MTFAC, vcfHeader, mutect2StatsTable);
        if (!mutect2StatsTable.exists()) {
            throw new UserException.CouldNotReadInputFile("Mutect stats table " + mutect2StatsTable + " not found.  When Mutect2 outputs a file calls.vcf it also creates a calls.vcf" + ".stats" + " file.  Perhaps this file was not moved along with the vcf, or perhaps it was not delocalized from a virtual machine while running in the cloud.");
        }
    }

    @Override
    protected void nthPassApply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext, int n) {
        ParamUtils.isPositiveOrZero(n, "Passes must start at the 0th pass.");
        if (n <= 2) {
            this.filteringEngine.accumulateData(variant, referenceContext);
        } else if (n == 3) {
            this.vcfWriter.add(this.filteringEngine.applyFiltersAndAccumulateOutputStats(variant, referenceContext));
        } else {
            throw new GATKException.ShouldNeverReachHereException("This walker should never reach (zero-indexed) pass " + n);
        }
    }

    @Override
    protected void afterNthPass(int n) {
        if (n < 2) {
            this.filteringEngine.learnParameters();
        } else if (n == 2) {
            this.filteringEngine.learnThreshold();
        } else if (n == 3) {
            Path filteringStats = IOUtils.getPath(this.filteringStatsOutput != null ? this.filteringStatsOutput : this.outputVcf + FILTERING_STATS_EXTENSION);
            this.filteringEngine.writeFilteringStats(filteringStats);
        } else {
            throw new GATKException.ShouldNeverReachHereException("This walker should never reach (zero-indexed) pass " + n);
        }
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }
}

