/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public class FilterStats {
    public static final String THRESHOLD_METADATA_TAG = "threshold";
    public static final String SENSITIVITY_METADATA_TAG = "sensitivity";
    public static final String FDR_METADATA_TAG = "fdr";
    private final String filterName;
    private final double falsePositiveCount;
    private final double falseDiscoveryRate;
    private final double falseNegativeCount;
    private final double falseNegativeRate;

    public FilterStats(String filterName, double falsePositiveCount, double falseDiscoveryRate, double falseNegativeCount, double falseNegativeRate) {
        this.filterName = filterName;
        this.falsePositiveCount = falsePositiveCount;
        this.falseDiscoveryRate = falseDiscoveryRate;
        this.falseNegativeCount = falseNegativeCount;
        this.falseNegativeRate = falseNegativeRate;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public double getFalsePositiveCount() {
        return this.falsePositiveCount;
    }

    public double getFalseDiscoveryRate() {
        return this.falseDiscoveryRate;
    }

    public double getFalseNegativeCount() {
        return this.falseNegativeCount;
    }

    public double getFalseNegativeRate() {
        return this.falseNegativeRate;
    }

    public static void writeM2FilterSummary(Collection<FilterStats> filterStats, Path outputTable, List<Pair<String, String>> clusteringMetadata, double threshold, double totalCalls, double expectedTruePositives, double expectedFalsePositives, double expectedFalseNegatives) {
        try (Mutect2FilterStatsWriter writer = new Mutect2FilterStatsWriter(outputTable);){
            for (Pair<String, String> pair : clusteringMetadata) {
                writer.writeMetadata((String)pair.getKey(), (String)pair.getValue());
            }
            writer.writeMetadata(THRESHOLD_METADATA_TAG, Double.toString(FilterStats.round(threshold)));
            writer.writeMetadata(FDR_METADATA_TAG, Double.toString(FilterStats.round(expectedFalsePositives / totalCalls)));
            writer.writeMetadata(SENSITIVITY_METADATA_TAG, Double.toString(FilterStats.round(expectedTruePositives / (expectedTruePositives + expectedFalseNegatives))));
            writer.writeAllRecords(filterStats);
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while writing to %s.", outputTable), e);
        }
    }

    private static double round(double x) {
        return MathUtils.roundToNDecimalPlaces(x, 3);
    }

    private static class Mutect2FilterStatsWriter
    extends TableWriter<FilterStats> {
        private Mutect2FilterStatsWriter(Path output) throws IOException {
            super(output, M2FilterStatsTableColumn.COLUMNS);
        }

        @Override
        protected void composeLine(FilterStats stats, DataLine dataLine) {
            dataLine.set(M2FilterStatsTableColumn.FILTER.toString(), stats.getFilterName()).set(M2FilterStatsTableColumn.FALSE_POSITIVE_COUNT.toString(), stats.getFalsePositiveCount(), 2).set(M2FilterStatsTableColumn.FALSE_DISCOVERY_RATE.toString(), stats.getFalseDiscoveryRate(), 2).set(M2FilterStatsTableColumn.FALSE_NEGATIVE_COUNT.toString(), stats.getFalseNegativeCount(), 2).set(M2FilterStatsTableColumn.FALSE_NEGATIVE_RATE.toString(), stats.getFalseNegativeRate(), 2);
        }
    }

    private static enum M2FilterStatsTableColumn {
        FILTER("filter"),
        FALSE_POSITIVE_COUNT("FP"),
        FALSE_DISCOVERY_RATE("FDR"),
        FALSE_NEGATIVE_COUNT("FN"),
        FALSE_NEGATIVE_RATE("FNR");

        private String columnName;
        public static final TableColumnCollection COLUMNS;

        private M2FilterStatsTableColumn(String columnName) {
            this.columnName = columnName;
        }

        public String toString() {
            return this.columnName;
        }

        static {
            COLUMNS = new TableColumnCollection((Object[])M2FilterStatsTableColumn.values());
        }
    }
}

