/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorProbabilities;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2Filter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2VariantFilter;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.variant.VariantContextGetters;

public class FilteredHaplotypeFilter
extends Mutect2VariantFilter {
    private final double maxIntraHaplotypeDistance;
    private Map<String, List<Pair<Integer, Double>>> accumulatingPhasedProbabilities = new HashMap<String, List<Pair<Integer, Double>>>();
    private Map<String, List<Pair<Integer, Double>>> phasedProbabilities = new HashMap<String, List<Pair<Integer, Double>>>();

    public FilteredHaplotypeFilter(double maxIntraHaplotypeDistance) {
        this.maxIntraHaplotypeDistance = maxIntraHaplotypeDistance;
    }

    @Override
    public ErrorType errorType() {
        return ErrorType.ARTIFACT;
    }

    @Override
    public double calculateErrorProbability(VariantContext vc, Mutect2FilteringEngine filteringEngine, ReferenceContext referenceContext) {
        Genotype tumorGenotype = vc.getGenotypes().stream().filter(filteringEngine::isTumor).max(Comparator.comparingDouble(g -> MathUtils.arrayMax(VariantContextGetters.getAttributeAsDoubleArray(g, "AF", () -> new double[]{0.0}, 0.0)))).get();
        Optional<String> phasingString = FilteredHaplotypeFilter.makePhasingString(tumorGenotype);
        if (!phasingString.isPresent()) {
            return 0.0;
        }
        List<Pair<Integer, Double>> phasedProbs = this.phasedProbabilities.get(phasingString.get());
        if (phasedProbs == null) {
            return 0.0;
        }
        return phasedProbs.stream().filter(pair -> (double)Math.abs((Integer)pair.getLeft() - vc.getStart()) <= this.maxIntraHaplotypeDistance).mapToDouble(Pair::getRight).max().orElse(0.0);
    }

    @Override
    protected void accumulateDataForLearning(VariantContext vc, ErrorProbabilities errorProbabilities, Mutect2FilteringEngine filteringEngine) {
        double artifactProbability = errorProbabilities.getProbabilitiesByFilter().entrySet().stream().filter(e -> ((Mutect2Filter)e.getKey()).errorType() != ErrorType.SEQUENCING).filter(e -> !((Mutect2Filter)e.getKey()).filterName().equals(this.filterName())).flatMap(e -> ((List)e.getValue()).stream()).max(Double::compareTo).orElse(0.0);
        for (Genotype tumorGenotype : vc.getGenotypes()) {
            Optional<String> phasingString;
            if (!filteringEngine.isTumor(tumorGenotype) || !(phasingString = FilteredHaplotypeFilter.makePhasingString(tumorGenotype)).isPresent()) continue;
            if (!this.accumulatingPhasedProbabilities.containsKey(phasingString.get())) {
                this.accumulatingPhasedProbabilities.put(phasingString.get(), new ArrayList());
            }
            this.accumulatingPhasedProbabilities.get(phasingString.get()).add((Pair<Integer, Double>)ImmutablePair.of((Object)vc.getStart(), (Object)artifactProbability));
        }
    }

    @Override
    protected void clearAccumulatedData() {
        this.accumulatingPhasedProbabilities = new HashMap<String, List<Pair<Integer, Double>>>();
    }

    @Override
    protected void learnParameters() {
        this.phasedProbabilities = this.accumulatingPhasedProbabilities;
    }

    @Override
    public String filterName() {
        return "haplotype";
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public Optional<String> phredScaledPosteriorAnnotationName() {
        return Optional.empty();
    }

    private static Optional<String> makePhasingString(Genotype genotype) {
        String pgt = (String)genotype.getExtendedAttribute("PGT", null);
        String pid = (String)genotype.getExtendedAttribute("PID", null);
        return pgt == null || pid == null ? Optional.empty() : Optional.of(pgt + pid);
    }
}

