/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorProbabilities;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.FilterStats;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2Filter;
import org.broadinstitute.hellbender.utils.IndexRange;

public class FilteringOutputStats {
    private int pass = 0;
    private double TPs = 0.0;
    private double FPs = 0.0;
    private double FNs = 0.0;
    private Map<Mutect2Filter, MutableDouble> filterFPs;
    private Map<Mutect2Filter, MutableDouble> filterFNs;
    private final List<Mutect2Filter> filters;

    public FilteringOutputStats(List<Mutect2Filter> filters) {
        this.filters = filters;
        this.filterFPs = this.makeEmptyFilterCounts();
        this.filterFNs = this.makeEmptyFilterCounts();
    }

    public void recordCall(ErrorProbabilities errorProbabilities, double threshold) {
        List<Double> probabilitiesPerAllele = errorProbabilities.getCombinedErrorProbabilities();
        List isFiltered = probabilitiesPerAllele.stream().map(p -> p > threshold).collect(Collectors.toList());
        probabilitiesPerAllele.stream().forEach(p -> {
            if (p > threshold) {
                this.FNs += 1.0 - p;
            } else {
                ++this.pass;
                this.FPs += p.doubleValue();
                this.TPs += 1.0 - p;
            }
        });
        new IndexRange(0, probabilitiesPerAllele.size()).forEach(i -> errorProbabilities.getProbabilitiesByFilter().entrySet().stream().forEach(entry -> {
            double alleleProb = (Double)((List)entry.getValue()).get(i);
            if (alleleProb > 1.0E-10 && alleleProb > threshold - 1.0E-10) {
                this.filterFNs.get(entry.getKey()).add(1.0 - (Double)probabilitiesPerAllele.get(i));
            } else if (!((Boolean)isFiltered.get(i)).booleanValue()) {
                this.filterFPs.get(entry.getKey()).add(alleleProb);
            }
        }));
    }

    public void writeFilteringStats(Path filteringStats, double threshold, List<Pair<String, String>> clusteringMetadata) {
        double totalTrueVariants = this.TPs + this.FNs;
        List<FilterStats> filterStats = this.filters.stream().map(f -> new FilterStats(f.filterName(), this.filterFPs.get(f).getValue(), this.filterFPs.get(f).getValue() / (double)this.pass, this.filterFNs.get(f).getValue(), this.filterFNs.get(f).getValue() / totalTrueVariants)).filter(stats -> stats.getFalsePositiveCount() > 0.0 || stats.getFalseNegativeCount() > 0.0).collect(Collectors.toList());
        FilterStats.writeM2FilterSummary(filterStats, filteringStats, clusteringMetadata, threshold, this.pass, this.TPs, this.FPs, this.FNs);
    }

    private Map<Mutect2Filter, MutableDouble> makeEmptyFilterCounts() {
        return this.filters.stream().collect(Collectors.toMap(f -> f, f -> new MutableDouble(0.0)));
    }

    public void clear() {
        this.pass = 0;
        this.TPs = 0.0;
        this.FPs = 0.0;
        this.FNs = 0.0;
        this.filterFPs = this.makeEmptyFilterCounts();
        this.filterFNs = this.makeEmptyFilterCounts();
    }
}

