/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.HardFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;

public class FragmentLengthFilter
extends HardFilter {
    private final double maxMedianFragmentLengthDifference;

    public FragmentLengthFilter(double maxMedianFragmentLengthDifference) {
        this.maxMedianFragmentLengthDifference = maxMedianFragmentLengthDifference;
    }

    @Override
    public ErrorType errorType() {
        return ErrorType.ARTIFACT;
    }

    @Override
    public boolean isArtifact(VariantContext vc, Mutect2FilteringEngine filteringEngine) {
        List fragmentLengthByAllele = vc.getAttributeAsIntList("MFRL", 0);
        return (double)Math.abs((Integer)fragmentLengthByAllele.get(1) - (Integer)fragmentLengthByAllele.get(0)) > this.maxMedianFragmentLengthDifference;
    }

    @Override
    public String filterName() {
        return "fragment";
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Collections.singletonList("MFRL");
    }
}

