/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.contamination.MinorAlleleFractionRecord;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2VariantFilter;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.NaturalLogUtils;
import org.broadinstitute.hellbender.utils.variant.VariantContextGetters;

public class GermlineFilter
extends Mutect2VariantFilter {
    private static final double MIN_ALLELE_FRACTION_FOR_GERMLINE_HOM_ALT = 0.9;
    private static final double EPSILON = 1.0E-10;
    private final Map<String, OverlapDetector<MinorAlleleFractionRecord>> tumorSegments;

    public GermlineFilter(List<File> tumorSegmentationTables) {
        this.tumorSegments = tumorSegmentationTables.stream().map(MinorAlleleFractionRecord::readFromFile).collect(Collectors.toMap(ImmutablePair::getLeft, p -> OverlapDetector.create((List)((List)p.getRight()))));
    }

    @Override
    public ErrorType errorType() {
        return ErrorType.NON_SOMATIC;
    }

    @Override
    public double calculateErrorProbability(VariantContext vc, Mutect2FilteringEngine filteringEngine, ReferenceContext referenceContext) {
        double[] somaticLogOdds = Mutect2FilteringEngine.getTumorLogOdds(vc);
        int maxLodIndex = MathUtils.maxElementIndex(somaticLogOdds);
        Optional normalLogOdds = vc.hasAttribute("NLOD") ? Optional.of(MathUtils.applyToArrayInPlace(VariantContextGetters.getAttributeAsDoubleArray(vc, "NLOD"), MathUtils::log10ToLog)) : Optional.empty();
        double[] negativeLog10AlleleFrequencies = VariantContextGetters.getAttributeAsDoubleArray(vc, "POPAF");
        double populationAF = Math.pow(10.0, -negativeLog10AlleleFrequencies[maxLodIndex]);
        if (populationAF < 1.0E-10) {
            return 0.0;
        }
        if (populationAF > 0.9999999999) {
            return 1.0;
        }
        int[] alleleCounts = filteringEngine.sumADsOverSamples(vc, true, false);
        int totalCount = (int)MathUtils.sum(alleleCounts);
        if (totalCount == 0) {
            return 0.0;
        }
        int refCount = alleleCounts[0];
        int altCount = alleleCounts[maxLodIndex + 1];
        double altAlleleFraction = filteringEngine.weightedAverageOfTumorAFs(vc)[maxLodIndex];
        double maf = this.computeMinorAlleleFraction(vc, filteringEngine, alleleCounts);
        double logGermlineLikelihood = NaturalLogUtils.LOG_ONE_HALF + NaturalLogUtils.logSumExp(new BinomialDistribution(null, totalCount, maf).logProbability(altCount), new BinomialDistribution(null, totalCount, 1.0 - maf).logProbability(altCount));
        double logSomaticLikelihood = filteringEngine.getSomaticClusteringModel().logLikelihoodGivenSomatic(totalCount, altCount);
        double logOddsOfGermlineHetVsSomatic = logGermlineLikelihood - logSomaticLikelihood;
        double logOddsOfGermlineHomAltVsSomatic = altAlleleFraction < 0.9 ? Double.NEGATIVE_INFINITY : 0.0;
        double normalLod = normalLogOdds.isPresent() ? ((double[])normalLogOdds.get())[maxLodIndex] : 0.0;
        return GermlineFilter.germlineProbability(-normalLod, logOddsOfGermlineHetVsSomatic, logOddsOfGermlineHomAltVsSomatic, populationAF, filteringEngine.getLogSomaticPrior(vc, maxLodIndex));
    }

    public static double germlineProbability(double normalLogOdds, double logOddsOfGermlineHetVsSomatic, double logOddsOfGermlineHomAltVsSomatic, double populationAF, double logPriorSomatic) {
        double logPriorNotSomatic = NaturalLogUtils.log1mexp(logPriorSomatic);
        double logPriorGermlineHet = Math.log(2.0 * populationAF * (1.0 - populationAF));
        double logPriorGermlineHomAlt = Math.log(MathUtils.square(populationAF));
        double logPriorNotGermline = Math.log(MathUtils.square(1.0 - populationAF));
        double logProbGermlineHet = logPriorGermlineHet + logOddsOfGermlineHetVsSomatic + normalLogOdds + logPriorNotSomatic;
        double logProbGermlineHomAlt = logPriorGermlineHomAlt + logOddsOfGermlineHomAltVsSomatic + normalLogOdds + logPriorNotSomatic;
        double logProbGermline = NaturalLogUtils.logSumExp(logProbGermlineHet, logProbGermlineHomAlt);
        double logProbSomatic = logPriorNotGermline + logPriorSomatic;
        return NaturalLogUtils.normalizeLog(new double[]{logProbGermline, logProbSomatic}, false, true)[0];
    }

    private double computeMinorAlleleFraction(VariantContext vc, Mutect2FilteringEngine filteringEngine, int[] alleleCounts) {
        MutableDouble weightedSumOfMafs = new MutableDouble(0.0);
        vc.getGenotypes().stream().filter(filteringEngine::isTumor).forEach(tumorGenotype -> {
            String sample = tumorGenotype.getSampleName();
            List segments = this.tumorSegments.containsKey(sample) ? this.tumorSegments.get(sample).getOverlaps((Locatable)vc).stream().collect(Collectors.toList()) : Collections.emptyList();
            double maf = segments.isEmpty() ? 0.5 : ((MinorAlleleFractionRecord)segments.get(0)).getMinorAlleleFraction();
            weightedSumOfMafs.add(maf * (double)MathUtils.sum(tumorGenotype.getAD()));
        });
        return weightedSumOfMafs.getValue() / (double)MathUtils.sum(alleleCounts);
    }

    @Override
    public String filterName() {
        return "germline";
    }

    @Override
    public Optional<String> phredScaledPosteriorAnnotationName() {
        return Optional.of("GERMQ");
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Arrays.asList("TLOD", "POPAF");
    }
}

