/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.TwoPassVariantWalker;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.AlleleFilterUtils;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2AlleleFilter;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import org.broadinstitute.hellbender.utils.variant.VariantContextGetters;
import picard.cmdline.programgroups.VariantFilteringProgramGroup;

@CommandLineProgramProperties(summary="If too many low heteroplasmy sites pass other filters, then filter all low heteroplasmy sites", oneLineSummary="If too many low het sites, filter all low het sites", programGroup=VariantFilteringProgramGroup.class)
public class MTLowHeteroplasmyFilterTool
extends TwoPassVariantWalker {
    public static final String MAX_ALLOWED_LOW_HETS_LONG_NAME = "max-allowed-low-hets";
    public static final String LOW_HET_THRESHOLD_LONG_NAME = "low-het-threshold";
    @Argument(fullName="output", shortName="O", doc="Output VCF file")
    private GATKPath outputVcf = null;
    @Argument(fullName="max-allowed-low-hets", doc="Number of low het sites allowed to pass other filters before filtering out all low het sites. Default is 3", optional=true)
    private int maxAllowedLowHets = 3;
    @Argument(fullName="low-het-threshold", doc="Threshold for determining a low heteroplasmy site. Default is 0.1", optional=true)
    private final double lowHetThreshold = 0.1;
    private boolean failedLowHet = false;
    private int unfilteredLowHetSites = 0;
    private VariantContextWriter vcfWriter;

    @Override
    public void onTraversalStart() {
        VCFHeader header = this.getHeaderForVariants();
        header.addMetaDataLine((VCFHeaderLine)GATKVCFHeaderLines.getFilterLine("mt_many_low_hets"));
        this.vcfWriter = this.createVCFWriter(this.outputVcf);
        this.vcfWriter.writeHeader(header);
    }

    @Override
    protected void firstPassApply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        if (variant.isNotFiltered() && this.isSiteLowHeteroplasmy(variant)) {
            ++this.unfilteredLowHetSites;
        }
    }

    @Override
    protected void afterFirstPass() {
        this.failedLowHet = this.unfilteredLowHetSites > this.maxAllowedLowHets;
    }

    @Override
    protected void secondPassApply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        VariantContextBuilder vcb = new VariantContextBuilder(variant);
        if (this.failedLowHet) {
            List<Boolean> appliedFilter = this.areAllelesArtifacts(variant);
            if (!appliedFilter.contains(Boolean.FALSE)) {
                vcb.filter(this.filterName());
            }
            if (appliedFilter.contains(Boolean.TRUE)) {
                vcb.attribute("AS_FilterStatus", (Object)AlleleFilterUtils.getMergedASFilterString(variant, appliedFilter, this.filterName()));
            }
        }
        this.vcfWriter.add(vcb.make());
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }

    protected String filterName() {
        return "mt_many_low_hets";
    }

    public List<Double> getData(Genotype g) {
        return Arrays.stream(VariantContextGetters.getAttributeAsDoubleArray(g, "AF", () -> null, Double.MAX_VALUE)).boxed().collect(Collectors.toList());
    }

    protected boolean isSiteLowHeteroplasmy(VariantContext v) {
        return !v.getGenotypes().stream().flatMap(g -> this.getData((Genotype)g).stream().filter(x -> x < 0.1)).collect(Collectors.toList()).isEmpty();
    }

    protected List<Boolean> areAllelesArtifacts(VariantContext vc) {
        LinkedHashMap dataByAllele = Mutect2AlleleFilter.getAltDataByAllele(vc, g -> g.hasExtendedAttribute("AF"), this::getData, null);
        return dataByAllele.values().stream().map(afList -> afList.stream().max(Double::compareTo).orElse(0.0) < 0.1).collect(Collectors.toList());
    }
}

