/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.HardAlleleFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;
import org.broadinstitute.hellbender.utils.IndexRange;

public class MappingQualityFilter
extends HardAlleleFilter {
    private final double minMedianMappingQuality;
    private final int longIndelSize;

    public MappingQualityFilter(double minMedianMappingQuality, int longIndelSize) {
        this.minMedianMappingQuality = minMedianMappingQuality;
        this.longIndelSize = longIndelSize;
    }

    @Override
    public ErrorType errorType() {
        return ErrorType.ARTIFACT;
    }

    @Override
    public List<Boolean> areAllelesArtifacts(VariantContext vc, Mutect2FilteringEngine filteringEngine, ReferenceContext referenceContext) {
        List indelLengths = vc.getIndelLengths();
        List mappingQualityByAllele = vc.getAttributeAsIntList("MMQ", 0);
        int refQual = (Integer)mappingQualityByAllele.remove(0);
        new IndexRange(0, mappingQualityByAllele.size()).forEach(i -> {
            if (indelLengths != null && (Integer)indelLengths.get(i) >= this.longIndelSize) {
                mappingQualityByAllele.set(i, refQual);
            }
        });
        return mappingQualityByAllele.stream().map(qual -> (double)qual.intValue() < this.minMedianMappingQuality).collect(Collectors.toList());
    }

    @Override
    public String filterName() {
        return "map_qual";
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Collections.singletonList("MMQ");
    }
}

