/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import com.google.common.primitives.Doubles;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.HardAlleleFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;
import org.broadinstitute.hellbender.utils.variant.VariantContextGetters;

public class MinAlleleFractionFilter
extends HardAlleleFilter {
    private final double minAf;

    public MinAlleleFractionFilter(double minAf) {
        this.minAf = minAf;
    }

    @Override
    public ErrorType errorType() {
        return ErrorType.ARTIFACT;
    }

    public List<Double> getAltData(Genotype g) {
        double[] data = VariantContextGetters.getAttributeAsDoubleArray(g, "AF", () -> null, 1.0);
        return Doubles.asList((double[])data);
    }

    @Override
    public List<Boolean> areAllelesArtifacts(VariantContext vc, Mutect2FilteringEngine filteringEngine, ReferenceContext referenceContext) {
        LinkedHashMap dataByAllele = MinAlleleFractionFilter.getAltDataByAllele(vc, g -> g.hasExtendedAttribute("AF") && filteringEngine.isTumor((Genotype)g), this::getAltData, filteringEngine);
        return dataByAllele.entrySet().stream().filter(entry -> !vc.getReference().equals(entry.getKey())).map(entry -> ((List)entry.getValue()).stream().max(Double::compare).orElse(1.0) < this.minAf).collect(Collectors.toList());
    }

    @Override
    public String filterName() {
        return "low_allele_frac";
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Collections.emptyList();
    }
}

