/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.HardFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;

public class MultiallelicFilter
extends HardFilter {
    private final int numAltAllelesThreshold;
    private static final double MULTIALLELIC_LOD_THRESHOLD = 5.0;

    public MultiallelicFilter(int numAltAllelesThreshold) {
        this.numAltAllelesThreshold = numAltAllelesThreshold;
    }

    @Override
    public ErrorType errorType() {
        return ErrorType.ARTIFACT;
    }

    @Override
    public boolean isArtifact(VariantContext vc, Mutect2FilteringEngine filteringEngine) {
        double[] tumorLods = Mutect2FilteringEngine.getTumorLogOdds(vc);
        long numPassingAltAlleles = Arrays.stream(tumorLods).filter(lod -> lod > 5.0).count();
        return numPassingAltAlleles > (long)this.numAltAllelesThreshold;
    }

    @Override
    public String filterName() {
        return "multiallelic";
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Collections.singletonList("TLOD");
    }
}

