/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2Filter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;

public abstract class Mutect2AlleleFilter
extends Mutect2Filter {
    public static <T> LinkedHashMap<Allele, List<T>> getDataByAllele(VariantContext vc, Predicate<Genotype> preconditions, Function<Genotype, List<T>> getData, Mutect2FilteringEngine filteringEngine) {
        LinkedHashMap dataByAllele = vc.getAlleles().stream().collect(Collectors.toMap(Function.identity(), allele -> new ArrayList(), (a, b) -> a, () -> new LinkedHashMap()));
        return Mutect2AlleleFilter.combineDataByAllele(dataByAllele, vc, preconditions, getData, filteringEngine);
    }

    public static <T> LinkedHashMap<Allele, List<T>> getAltDataByAllele(VariantContext vc, Predicate<Genotype> preconditions, Function<Genotype, List<T>> getAltData, Mutect2FilteringEngine filteringEngine) {
        LinkedHashMap dataByAllele = vc.getAlternateAlleles().stream().collect(Collectors.toMap(Function.identity(), allele -> new ArrayList(), (a, b) -> a, () -> new LinkedHashMap()));
        return Mutect2AlleleFilter.combineDataByAllele(dataByAllele, vc, preconditions, getAltData, filteringEngine);
    }

    private static <T> LinkedHashMap<Allele, List<T>> combineDataByAllele(LinkedHashMap<Allele, List<T>> dataByAllele, VariantContext vc, Predicate<Genotype> preconditions, Function<Genotype, List<T>> getData, Mutect2FilteringEngine filteringEngine) {
        vc.getGenotypes().stream().filter(preconditions).forEach(g -> {
            Iterator alleleDataIterator = ((List)getData.apply((Genotype)g)).iterator();
            Iterator dataByAlleleIterator = dataByAllele.values().iterator();
            while (alleleDataIterator.hasNext() && dataByAlleleIterator.hasNext()) {
                ((List)dataByAlleleIterator.next()).add(alleleDataIterator.next());
            }
        });
        return dataByAllele;
    }

    @Override
    public List<Double> errorProbabilities(VariantContext vc, Mutect2FilteringEngine filteringEngine, ReferenceContext referenceContext) {
        return this.requiredInfoAnnotations().stream().allMatch(arg_0 -> ((VariantContext)vc).hasAttribute(arg_0)) ? this.calculateErrorProbabilityForAlleles(vc, filteringEngine, referenceContext).stream().map(prob -> Mutect2FilteringEngine.roundFinitePrecisionErrors(prob)).collect(Collectors.toList()) : Collections.emptyList();
    }

    protected abstract List<Double> calculateErrorProbabilityForAlleles(VariantContext var1, Mutect2FilteringEngine var2, ReferenceContext var3);
}

