/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorProbabilities;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;

public abstract class Mutect2Filter {
    protected void accumulateDataForLearning(VariantContext vc, ErrorProbabilities errorProbabilities, Mutect2FilteringEngine filteringEngine) {
    }

    protected void clearAccumulatedData() {
    }

    protected void learnParameters() {
    }

    protected void learnParametersAndClearAccumulatedData() {
        this.learnParameters();
        this.clearAccumulatedData();
    }

    public abstract ErrorType errorType();

    public abstract String filterName();

    public abstract Optional<String> phredScaledPosteriorAnnotationName();

    protected abstract List<String> requiredInfoAnnotations();

    public abstract List<Double> errorProbabilities(VariantContext var1, Mutect2FilteringEngine var2, ReferenceContext var3);

    protected static double weightedMedianPosteriorProbability(List<ImmutablePair<Integer, Double>> depthsAndPosteriors) {
        int totalAltDepth = depthsAndPosteriors.stream().mapToInt(ImmutablePair::getLeft).sum();
        depthsAndPosteriors.sort(Comparator.comparingDouble(p -> (Double)p.getRight()));
        int cumulativeAltCount = 0;
        for (ImmutablePair<Integer, Double> pair : depthsAndPosteriors) {
            if ((cumulativeAltCount += ((Integer)pair.getLeft()).intValue()) * 2 < totalAltDepth) continue;
            return (Double)pair.getRight();
        }
        return 0.0;
    }
}

