/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.math3.util.MathArrays;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.AnnotationUtils;
import org.broadinstitute.hellbender.tools.walkers.mutect.MutectStats;
import org.broadinstitute.hellbender.tools.walkers.mutect.clustering.SomaticClusteringModel;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.BaseQualityFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ClusteredEventsFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ContaminationFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.DuplicatedAltReadFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorProbabilities;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.FilteredHaplotypeFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.FilteringOutputStats;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.FragmentLengthFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.GermlineFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.M2FiltersArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.MappingQualityFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.MinAlleleFractionFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.MultiallelicFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2Filter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.NRatioFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.NormalArtifactFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.PanelOfNormalsFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.PolymeraseSlippageFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ReadOrientationFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ReadPositionFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.StrandArtifactFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.StrictStrandBiasFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ThresholdCalculator;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.TumorEvidenceFilter;
import org.broadinstitute.hellbender.utils.IndexRange;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.NaturalLogUtils;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.VariantContextGetters;

public class Mutect2FilteringEngine {
    public static final double EPSILON = 1.0E-10;
    public static final double MIN_REPORTABLE_ERROR_PROBABILITY = 0.1;
    private final List<Mutect2Filter> filters = new ArrayList<Mutect2Filter>();
    private final Set<String> normalSamples;
    public static final List<String> STANDARD_MUTECT_INFO_FIELDS_FOR_FILTERING = Arrays.asList("MMQ", "MBQ", "MPOS", "MFRL");
    private final ThresholdCalculator thresholdCalculator;
    private final FilteringOutputStats filteringOutputStats;
    private final SomaticClusteringModel somaticClusteringModel;

    public Mutect2FilteringEngine(M2FiltersArgumentCollection MTFAC, VCFHeader vcfHeader, File mutectStatsTable) {
        this.thresholdCalculator = new ThresholdCalculator(MTFAC.thresholdStrategy, MTFAC.initialPosteriorThreshold, MTFAC.maxFalsePositiveRate, MTFAC.fScoreBeta);
        this.somaticClusteringModel = new SomaticClusteringModel(MTFAC, mutectStatsTable.exists() ? MutectStats.readFromFile(mutectStatsTable) : Collections.emptyList());
        this.normalSamples = vcfHeader.getMetaDataInInputOrder().stream().filter(line -> line.getKey().equals("normal_sample")).map(VCFHeaderLine::getValue).collect(Collectors.toSet());
        this.buildFiltersList(MTFAC);
        this.filteringOutputStats = new FilteringOutputStats(this.filters);
    }

    public boolean isNormal(Genotype genotype) {
        return this.normalSamples.contains(genotype.getSampleName());
    }

    public boolean isTumor(Genotype genotype) {
        return !this.isNormal(genotype);
    }

    public double getThreshold() {
        return this.thresholdCalculator.getThreshold();
    }

    public SomaticClusteringModel getSomaticClusteringModel() {
        return this.somaticClusteringModel;
    }

    public double posteriorProbabilityOfError(VariantContext vc, double logOddsOfRealVersusError, int altIndex) {
        return Mutect2FilteringEngine.posteriorProbabilityOfError(logOddsOfRealVersusError, this.getLogSomaticPrior(vc, altIndex));
    }

    public double posteriorProbabilityOfNormalArtifact(double negativeLogOddsOfNormalArtifact) {
        return Mutect2FilteringEngine.posteriorProbabilityOfError(negativeLogOddsOfNormalArtifact, this.somaticClusteringModel.getLogPriorOfVariantVersusArtifact());
    }

    public double getLogSomaticPrior(VariantContext vc, int altIndex) {
        return this.somaticClusteringModel.getLogPriorOfSomaticVariant(vc, altIndex);
    }

    public static double posteriorProbabilityOfError(double logOddsOfRealVersusError, double logPriorOfReal) {
        double[] unweightedPosteriorOfRealAndError = new double[]{logOddsOfRealVersusError + logPriorOfReal, NaturalLogUtils.log1mexp(logPriorOfReal)};
        double[] posteriorOfRealAndError = NaturalLogUtils.normalizeFromLogToLinearSpace(unweightedPosteriorOfRealAndError);
        return posteriorOfRealAndError[1];
    }

    public int[] sumADsOverSamples(VariantContext vc, boolean includeTumor, boolean includeNormal) {
        int[] ADs = new int[vc.getNAlleles()];
        vc.getGenotypes().stream().filter(g -> includeTumor && this.isTumor((Genotype)g) || includeNormal && this.isNormal((Genotype)g)).map(Genotype::getAD).forEach(ad -> new IndexRange(0, vc.getNAlleles()).forEach(n -> {
            int n2 = n;
            ADs[n2] = ADs[n2] + ad[n];
        }));
        return ADs;
    }

    public double[] weightedAverageOfTumorAFs(VariantContext vc) {
        MutableDouble totalWeight = new MutableDouble(0.0);
        double[] AFs = new double[vc.getNAlleles() - 1];
        vc.getGenotypes().stream().filter(this::isTumor).forEach(g -> {
            double weight = MathUtils.sum(g.getAD());
            totalWeight.add(weight);
            double[] sampleAFs = VariantContextGetters.getAttributeAsDoubleArray(g, "AF", () -> new double[]{0.0}, 0.0);
            MathArrays.scaleInPlace((double)weight, (double[])sampleAFs);
            MathUtils.addToArrayInPlace(AFs, sampleAFs);
        });
        MathArrays.scaleInPlace((double)(1.0 / totalWeight.getValue()), (double[])AFs);
        return AFs;
    }

    public static double[] getTumorLogOdds(VariantContext vc) {
        double[] tumorLog10Odds = VariantContextGetters.getAttributeAsDoubleArray(vc, "TLOD");
        return tumorLog10Odds == null ? null : MathUtils.applyToArrayInPlace(tumorLog10Odds, MathUtils::log10ToLog);
    }

    public void accumulateData(VariantContext vc, ReferenceContext referenceContext) {
        if (vc.getAlleles().stream().noneMatch(a -> a.isNonReference() && !a.isNonRefAllele())) {
            return;
        }
        ErrorProbabilities errorProbabilities = new ErrorProbabilities(this.filters, vc, this, referenceContext);
        this.filters.forEach(f -> f.accumulateDataForLearning(vc, errorProbabilities, this));
        int[] tumorADs = this.sumADsOverSamples(vc, true, false);
        double[] tumorLogOdds = Mutect2FilteringEngine.getTumorLogOdds(vc);
        this.somaticClusteringModel.record(tumorADs, tumorLogOdds, errorProbabilities.getTechnicalArtifactProbabilities(), errorProbabilities.getNonSomaticProbabilities(), vc);
        this.thresholdCalculator.addCombinedErrorProbabilites(errorProbabilities.getCombinedErrorProbabilities());
    }

    public void learnParameters() {
        this.filters.forEach(Mutect2Filter::learnParametersAndClearAccumulatedData);
        this.somaticClusteringModel.learnAndClearAccumulatedData();
        this.thresholdCalculator.relearnThresholdAndClearAcumulatedProbabilities();
        this.filteringOutputStats.clear();
    }

    public void learnThreshold() {
        this.thresholdCalculator.relearnThresholdAndClearAcumulatedProbabilities();
        this.filteringOutputStats.clear();
    }

    public VariantContext applyFiltersAndAccumulateOutputStats(VariantContext vc, ReferenceContext referenceContext) {
        List filtersNonSymbolicAlleles;
        VariantContextBuilder vcb = new VariantContextBuilder(vc).filters(new HashSet());
        ErrorProbabilities errorProbabilities = new ErrorProbabilities(this.filters, vc, this, referenceContext);
        this.filteringOutputStats.recordCall(errorProbabilities, this.getThreshold() - 1.0E-10);
        double errorThreshold = Math.min(0.9999999999, Math.max(1.0E-10, this.getThreshold()));
        LinkedHashMap<String, Double> siteFiltersWithErrorProb = new LinkedHashMap<String, Double>();
        List alleleStatusByFilter = errorProbabilities.getProbabilitiesForAlleleFilters().entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).map(entry -> this.addFilterStrings((List)entry.getValue(), errorThreshold, ((Mutect2Filter)entry.getKey()).filterName())).collect(Collectors.toList());
        List filtersByAllele = ErrorProbabilities.transpose(alleleStatusByFilter);
        List distinctFiltersByAllele = filtersByAllele.stream().map(this::getDistinctFiltersForAllele).collect(Collectors.toList());
        ListIterator mergedFilterStringByAllele = distinctFiltersByAllele.stream().map(AnnotationUtils::encodeStringList).collect(Collectors.toList()).listIterator();
        List orderedASFilterStrings = vc.getAlternateAlleles().stream().map(allele -> allele.isSymbolic() ? "SITE" : (String)mergedFilterStringByAllele.next()).collect(Collectors.toList());
        String finalAttrString = AnnotationUtils.encodeAnyASListWithRawDelim(orderedASFilterStrings);
        vcb.putAttributes(Collections.singletonMap("AS_FilterStatus", finalAttrString));
        alleleStatusByFilter.stream().forEachOrdered(alleleStatusForFilter -> {
            if (!alleleStatusForFilter.isEmpty() && alleleStatusForFilter.stream().distinct().count() == 1L && !alleleStatusForFilter.contains("SITE")) {
                siteFiltersWithErrorProb.put((String)alleleStatusForFilter.get(0), 1.0);
            }
        });
        errorProbabilities.getProbabilitiesForVariantFilters().entrySet().stream().forEach(entry -> {
            ((Mutect2Filter)entry.getKey()).phredScaledPosteriorAnnotationName().ifPresent(annotation -> {
                if (((Mutect2Filter)entry.getKey()).requiredInfoAnnotations().stream().allMatch(arg_0 -> ((VariantContext)vc).hasAttribute(arg_0))) {
                    vcb.attribute(annotation, (Object)QualityUtils.errorProbToQual((Double)entry.getValue()));
                }
            });
            if ((Double)entry.getValue() > errorThreshold) {
                siteFiltersWithErrorProb.put(((Mutect2Filter)entry.getKey()).filterName(), (Double)entry.getValue());
            }
        });
        if (siteFiltersWithErrorProb.isEmpty() && !distinctFiltersByAllele.stream().allMatch(List::isEmpty) && !(filtersNonSymbolicAlleles = GATKVariantContextUtils.removeDataForSymbolicAltAlleles(vc, distinctFiltersByAllele)).stream().anyMatch(filterList -> filterList.contains("SITE"))) {
            siteFiltersWithErrorProb.put("FAIL", 1.0);
        }
        double maxErrorProb = siteFiltersWithErrorProb.values().stream().mapToDouble(p -> p).max().orElse(1.0);
        siteFiltersWithErrorProb.entrySet().stream().forEach(entry -> {
            if ((Double)entry.getValue() >= Math.min(maxErrorProb, 0.1)) {
                vcb.filter((String)entry.getKey());
            }
        });
        return vcb.make();
    }

    private List<String> getDistinctFiltersForAllele(List<String> filtersForAllele) {
        List<String> results = filtersForAllele.stream().distinct().collect(Collectors.toList());
        if (results.size() > 1 && results.contains("SITE")) {
            results.remove("SITE");
        }
        if (results.isEmpty()) {
            results.add("SITE");
        }
        return results;
    }

    private List<String> addFilterStrings(List<Double> probabilities, double errorThreshold, String filterName) {
        return probabilities.stream().map(value -> value > errorThreshold ? filterName : "SITE").collect(Collectors.toList());
    }

    public static double roundFinitePrecisionErrors(double probability) {
        return Math.max(Math.min(probability, 1.0), 0.0);
    }

    public void writeFilteringStats(Path filteringStats) {
        this.filteringOutputStats.writeFilteringStats(filteringStats, this.getThreshold(), this.somaticClusteringModel.clusteringMetadata());
    }

    private void buildFiltersList(M2FiltersArgumentCollection MTFAC) {
        this.filters.add(new TumorEvidenceFilter());
        this.filters.add(new BaseQualityFilter(MTFAC.minMedianBaseQuality));
        this.filters.add(new MappingQualityFilter(MTFAC.minMedianMappingQuality, MTFAC.longIndelLength));
        this.filters.add(new DuplicatedAltReadFilter(MTFAC.uniqueAltReadCount));
        this.filters.add(new StrandArtifactFilter());
        this.filters.add(new ContaminationFilter(MTFAC.contaminationTables, MTFAC.contaminationEstimate));
        this.filters.add(new StrictStrandBiasFilter(MTFAC.minReadsOnEachStrand));
        this.filters.add(new ReadPositionFilter(MTFAC.minMedianReadPosition));
        this.filters.add(new MinAlleleFractionFilter(MTFAC.minAf));
        this.filters.add(new NormalArtifactFilter(MTFAC.normalPileupPValueThreshold));
        this.filters.add(new NRatioFilter(MTFAC.nRatio));
        this.filters.add(new PanelOfNormalsFilter());
        if (!MTFAC.readOrientationPriorTarGzs.isEmpty()) {
            List<File> artifactTables = MTFAC.readOrientationPriorTarGzs.stream().flatMap(tarGz -> {
                File extractDir = IOUtils.createTempDir("extract");
                IOUtils.extractTarGz(tarGz.toPath(), extractDir.toPath());
                return Arrays.stream(extractDir.listFiles());
            }).collect(Collectors.toList());
            this.filters.add(new ReadOrientationFilter(artifactTables));
        }
        if (!MTFAC.mitochondria) {
            this.filters.add(new ClusteredEventsFilter(MTFAC.maxEventsInRegion));
            this.filters.add(new MultiallelicFilter(MTFAC.numAltAllelesThreshold));
            this.filters.add(new FragmentLengthFilter(MTFAC.maxMedianFragmentLengthDifference));
            this.filters.add(new PolymeraseSlippageFilter(MTFAC.minSlippageLength, MTFAC.slippageRate));
            this.filters.add(new FilteredHaplotypeFilter(MTFAC.maxDistanceToFilteredCallOnSameHaplotype));
            this.filters.add(new GermlineFilter(MTFAC.tumorSegmentationTables));
        }
    }
}

