/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.HardFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;
import org.broadinstitute.hellbender.utils.MathUtils;

public class NRatioFilter
extends HardFilter {
    private final double maxNRatio;

    public NRatioFilter(double maxNRatio) {
        this.maxNRatio = maxNRatio;
    }

    @Override
    public ErrorType errorType() {
        return ErrorType.ARTIFACT;
    }

    @Override
    public boolean isArtifact(VariantContext vc, Mutect2FilteringEngine filteringEngine) {
        int[] ADs = filteringEngine.sumADsOverSamples(vc, true, true);
        int altCount = (int)MathUtils.sum(ADs) - ADs[0];
        if (altCount == 0) {
            return false;
        }
        int NCount = vc.getAttributeAsInt("NCount", 0);
        return (double)NCount / (double)altCount >= this.maxNRatio;
    }

    @Override
    public String filterName() {
        return "n_ratio";
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Collections.singletonList("NCount");
    }
}

