/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2VariantFilter;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.variant.VariantContextGetters;

public class NormalArtifactFilter
extends Mutect2VariantFilter {
    private static final double MIN_NORMAL_ARTIFACT_RATIO = 0.1;
    private static final int IMPUTED_NORMAL_BASE_QUALITY = 30;
    private final double normalPileupPValueThreshold;

    public NormalArtifactFilter(double normalPileupPValueThreshold) {
        this.normalPileupPValueThreshold = normalPileupPValueThreshold;
    }

    @Override
    public ErrorType errorType() {
        return ErrorType.ARTIFACT;
    }

    @Override
    public double calculateErrorProbability(VariantContext vc, Mutect2FilteringEngine filteringEngine, ReferenceContext referenceContext) {
        double normalAlleleFraction;
        double[] tumorLods = Mutect2FilteringEngine.getTumorLogOdds(vc);
        int indexOfMaxTumorLod = MathUtils.maxElementIndex(tumorLods);
        int[] tumorAlleleDepths = filteringEngine.sumADsOverSamples(vc, true, false);
        int tumorDepth = (int)MathUtils.sum(tumorAlleleDepths);
        int tumorAltDepth = tumorAlleleDepths[indexOfMaxTumorLod + 1];
        int[] normalAlleleDepths = filteringEngine.sumADsOverSamples(vc, false, true);
        int normalDepth = (int)MathUtils.sum(normalAlleleDepths);
        int normalAltDepth = normalAlleleDepths[indexOfMaxTumorLod + 1];
        double tumorAlleleFraction = (double)tumorAltDepth / (double)tumorDepth;
        double d = normalAlleleFraction = normalDepth == 0 ? 0.0 : (double)normalAltDepth / (double)normalDepth;
        if (normalAlleleFraction < 0.1 * tumorAlleleFraction) {
            return 0.0;
        }
        double[] normalArtifactNegativeLogOdds = MathUtils.applyToArrayInPlace(VariantContextGetters.getAttributeAsDoubleArray(vc, "NALOD"), MathUtils::log10ToLog);
        double normalArtifactProbability = filteringEngine.posteriorProbabilityOfNormalArtifact(normalArtifactNegativeLogOdds[indexOfMaxTumorLod]);
        int medianRefBaseQuality = (Integer)vc.getAttributeAsIntList("MBQ", 30).get(0);
        double normalPValue = 1.0 - new BinomialDistribution(null, normalDepth, QualityUtils.qualToErrorProb(medianRefBaseQuality)).cumulativeProbability(normalAltDepth - 1);
        return normalPValue < this.normalPileupPValueThreshold ? 1.0 : normalArtifactProbability;
    }

    @Override
    public Optional<String> phredScaledPosteriorAnnotationName() {
        return Optional.empty();
    }

    @Override
    public String filterName() {
        return "normal_artifact";
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Arrays.asList("NALOD", "TLOD");
    }
}

