/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.AlleleFilterUtils;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2AlleleFilter;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import picard.cmdline.programgroups.VariantFilteringProgramGroup;

@CommandLineProgramProperties(summary="Uses the median autosomal coverage and the allele depth to determine whether the allele might be a NuMT", oneLineSummary="Uses the median autosomal coverage and the allele depth to determine whether the allele might be a NuMT", programGroup=VariantFilteringProgramGroup.class)
public class NuMTFilterTool
extends VariantWalker {
    public static final String MEDIAN_AUTOSOMAL_COVERAGE_LONG_NAME = "autosomal-coverage";
    public static final String MAX_NUMT_COPIES_IN_AUTOSOME_LONG_NAME = "max-numt-autosomal-copies";
    private static final double DEFAULT_MEDIAN_AUTOSOMAL_COVERAGE = 0.0;
    @VisibleForTesting
    static final double DEFAULT_MAX_NUMT_AUTOSOMAL_COPIES = 4.0;
    @Argument(fullName="output", shortName="O", doc="Output VCF file")
    private GATKPath outputVcf = null;
    @Argument(fullName="autosomal-coverage", optional=true, doc="Median autosomal coverage for filtering potential NuMTs when calling on mitochondria.")
    public double medianAutosomalCoverage = 0.0;
    @Argument(fullName="max-numt-autosomal-copies", optional=true, doc="Max expected NUMT copies in autosome used for filtering potential NuMTs when calling on mitochondria.")
    public double maxNuMTAutosomalCopies = 4.0;
    private VariantContextWriter vcfWriter;
    private static final double LOWER_BOUND_PROB = 0.01;
    private int maxAltDepthCutoff = 0;

    @Override
    public void onTraversalStart() {
        VCFHeader header = this.getHeaderForVariants();
        header.addMetaDataLine((VCFHeaderLine)GATKVCFHeaderLines.getFilterLine("possible_numt"));
        this.vcfWriter = this.createVCFWriter(this.outputVcf);
        this.vcfWriter.writeHeader(header);
        if (this.maxNuMTAutosomalCopies > 0.0 && this.medianAutosomalCoverage > 0.0) {
            this.maxAltDepthCutoff = NuMTFilterTool.getMaxAltDepthCutoff(this.maxNuMTAutosomalCopies, this.medianAutosomalCoverage);
        }
    }

    @VisibleForTesting
    static int getMaxAltDepthCutoff(double maxNuMTAutosomalCopies, double medianAutosomalCoverage) {
        PoissonDistribution autosomalCoverage = new PoissonDistribution(medianAutosomalCoverage * maxNuMTAutosomalCopies / 2.0);
        return autosomalCoverage.inverseCumulativeProbability(0.99);
    }

    public List<Integer> getData(Genotype g) {
        return Arrays.stream(g.getAD()).boxed().collect(Collectors.toList());
    }

    @Override
    public void apply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        VariantContextBuilder vcb = new VariantContextBuilder(variant);
        LinkedHashMap dataByAllele = Mutect2AlleleFilter.getDataByAllele(variant, Genotype::hasAD, this::getData, null);
        List<Boolean> appliedFilter = dataByAllele.entrySet().stream().filter(entry -> !variant.getReference().equals(entry.getKey())).map(entry -> ((List)entry.getValue()).stream().max(Integer::compare).orElse(0) < this.maxAltDepthCutoff).collect(Collectors.toList());
        if (!appliedFilter.contains(Boolean.FALSE)) {
            vcb.filter(this.filterName());
        }
        if (appliedFilter.contains(Boolean.TRUE)) {
            vcb.attribute("AS_FilterStatus", (Object)AlleleFilterUtils.getMergedASFilterString(variant, appliedFilter, this.filterName()));
        }
        this.vcfWriter.add(vcb.make());
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }

    public String filterName() {
        return "possible_numt";
    }
}

