/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.special.Beta;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2VariantFilter;
import org.broadinstitute.hellbender.utils.MathUtils;

public class PolymeraseSlippageFilter
extends Mutect2VariantFilter {
    private final int minSlippageLength;
    private final double slippageRate;

    public PolymeraseSlippageFilter(int minSlippageLength, double slippageRate) {
        this.minSlippageLength = minSlippageLength;
        this.slippageRate = slippageRate;
    }

    @Override
    public ErrorType errorType() {
        return ErrorType.ARTIFACT;
    }

    @Override
    public double calculateErrorProbability(VariantContext vc, Mutect2FilteringEngine filteringEngine, ReferenceContext referenceContext) {
        int[] rpa = vc.getAttributeAsList("RPA").stream().mapToInt(o -> Integer.parseInt(String.valueOf(o))).toArray();
        if (rpa.length < 2) {
            return 0.0;
        }
        String ru = vc.getAttributeAsString("RU", "");
        int referenceSTRBaseCount = ru.length() * rpa[0];
        int numPCRSlips = rpa[0] - rpa[1];
        if (referenceSTRBaseCount >= this.minSlippageLength && Math.abs(numPCRSlips) == 1) {
            double likelihoodGivenSlippageArtifact;
            int[] ADs = filteringEngine.sumADsOverSamples(vc, true, false);
            if (ADs == null || ADs.length < 2) {
                return 0.0;
            }
            int depth = (int)MathUtils.sum(ADs);
            int altCount = (int)MathUtils.sum(ADs) - ADs[0];
            double logSomaticLikelihood = filteringEngine.getSomaticClusteringModel().logLikelihoodGivenSomatic(depth, altCount);
            try {
                likelihoodGivenSlippageArtifact = Beta.regularizedBeta((double)this.slippageRate, (double)(ADs[1] + 1), (double)(ADs[0] + 1));
            }
            catch (MaxCountExceededException e) {
                likelihoodGivenSlippageArtifact = new BinomialDistribution(null, depth, this.slippageRate).probability(ADs[1]);
            }
            double logOdds = logSomaticLikelihood - Math.log(likelihoodGivenSlippageArtifact);
            return filteringEngine.posteriorProbabilityOfError(vc, logOdds, 0);
        }
        return 0.0;
    }

    @Override
    public Optional<String> phredScaledPosteriorAnnotationName() {
        return Optional.of("STRQ");
    }

    @Override
    public String filterName() {
        return "slippage";
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Arrays.asList("RPA", "RU");
    }
}

