/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.HardAlleleFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;

public class ReadPositionFilter
extends HardAlleleFilter {
    private final double minMedianReadPosition;

    public ReadPositionFilter(double minMedianReadPosition) {
        this.minMedianReadPosition = minMedianReadPosition;
    }

    @Override
    public ErrorType errorType() {
        return ErrorType.ARTIFACT;
    }

    @Override
    public List<Boolean> areAllelesArtifacts(VariantContext vc, Mutect2FilteringEngine filteringEngine, ReferenceContext referenceContext) {
        List readPositionByAllele = vc.getAttributeAsIntList("MPOS", 0);
        return readPositionByAllele.subList(0, readPositionByAllele.size()).stream().map(readPos -> readPos > -1 && (double)readPos.intValue() < this.minMedianReadPosition).collect(Collectors.toList());
    }

    @Override
    public String filterName() {
        return "position";
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Collections.singletonList("MPOS");
    }
}

