/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public class ThresholdCalculator {
    private final Strategy strategy;
    private final double maxFalseDiscoveryRate;
    private final double fScoreBeta;
    private double threshold;
    final List<Double> errorProbabilities = new ArrayList<Double>();

    public ThresholdCalculator(Strategy strategy, double initialThreshold, double maxFalseDiscoveryRate, double fScoreBeta) {
        this.strategy = strategy;
        this.threshold = initialThreshold;
        this.maxFalseDiscoveryRate = maxFalseDiscoveryRate;
        this.fScoreBeta = fScoreBeta;
    }

    public void addCombinedErrorProbabilites(List<Double> errorProbabilities) {
        this.errorProbabilities.addAll(errorProbabilities);
    }

    public void relearnThresholdAndClearAcumulatedProbabilities() {
        switch (this.strategy) {
            case CONSTANT: {
                break;
            }
            case FALSE_DISCOVERY_RATE: {
                this.threshold = ThresholdCalculator.calculateThresholdBasedOnFalseDiscoveryRate(this.errorProbabilities, this.maxFalseDiscoveryRate);
                break;
            }
            case OPTIMAL_F_SCORE: {
                this.threshold = ThresholdCalculator.calculateThresholdBasedOnOptimalFScore(this.errorProbabilities, this.fScoreBeta);
                break;
            }
            default: {
                throw new GATKException.ShouldNeverReachHereException("Invalid threshold strategy type: " + (Object)((Object)this.strategy) + ".");
            }
        }
        this.clear();
    }

    public void clear() {
        this.errorProbabilities.clear();
    }

    public double getThreshold() {
        return this.threshold;
    }

    @VisibleForTesting
    static double calculateThresholdBasedOnOptimalFScore(List<Double> posteriors, double beta) {
        ParamUtils.isPositiveOrZero(beta, "requested F-score beta must be non-negative");
        Collections.sort(posteriors);
        double expectedTruePositives = posteriors.stream().mapToDouble(prob -> 1.0 - prob).sum();
        MutableDouble truePositives = new MutableDouble(0.0);
        MutableDouble falsePositives = new MutableDouble(0.0);
        MutableDouble falseNegatives = new MutableDouble(expectedTruePositives);
        int optimalIndexInclusive = -1;
        double optimalFScore = 0.0;
        int N = posteriors.size();
        for (int n = 0; n < N; ++n) {
            truePositives.add(1.0 - posteriors.get(n));
            falsePositives.add((Number)posteriors.get(n));
            falseNegatives.subtract(1.0 - posteriors.get(n));
            double F = (1.0 + beta * beta) * truePositives.getValue() / ((1.0 + beta * beta) * truePositives.getValue() + beta * beta * falseNegatives.getValue() + falsePositives.getValue());
            if (!(F >= optimalFScore)) continue;
            optimalIndexInclusive = n;
            optimalFScore = F;
        }
        return optimalIndexInclusive == -1 ? 0.0 : (optimalIndexInclusive == N - 1 ? 1.0 : posteriors.get(optimalIndexInclusive));
    }

    @VisibleForTesting
    public static double calculateThresholdBasedOnFalseDiscoveryRate(List<Double> posteriors, double requestedFPR) {
        ParamUtils.isPositiveOrZero(requestedFPR, "requested FPR must be non-negative");
        double thresholdForFilteringNone = 1.0;
        double thresholdForFilteringAll = 0.0;
        Collections.sort(posteriors);
        int numPassingVariants = posteriors.size();
        double cumulativeExpectedFPs = 0.0;
        for (int i = 0; i < numPassingVariants; ++i) {
            double posterior = posteriors.get(i);
            double expectedFPR = (cumulativeExpectedFPs + posterior) / (double)(i + 1);
            if (expectedFPR > requestedFPR) {
                return i > 0 ? posteriors.get(i - 1) : 0.0;
            }
            cumulativeExpectedFPs += posterior;
        }
        return 1.0;
    }

    public static enum Strategy {
        CONSTANT,
        FALSE_DISCOVERY_RATE,
        OPTIMAL_F_SCORE;

    }
}

