/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect.filtering;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.mutect.clustering.Datum;
import org.broadinstitute.hellbender.tools.walkers.mutect.clustering.SomaticClusteringModel;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.ErrorType;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2AlleleFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;
import org.broadinstitute.hellbender.utils.MathUtils;

public class TumorEvidenceFilter
extends Mutect2AlleleFilter {
    @Override
    public ErrorType errorType() {
        return ErrorType.SEQUENCING;
    }

    @Override
    protected List<Double> calculateErrorProbabilityForAlleles(VariantContext vc, Mutect2FilteringEngine filteringEngine, ReferenceContext referenceContext) {
        double[] tumorLods = Mutect2FilteringEngine.getTumorLogOdds(vc);
        int[] ADs = filteringEngine.sumADsOverSamples(vc, true, false);
        int totalCount = (int)MathUtils.sum(ADs);
        SomaticClusteringModel model = filteringEngine.getSomaticClusteringModel();
        return IntStream.range(0, tumorLods.length).mapToObj(i -> new Datum(tumorLods[i], 0.0, 0.0, ADs[i + 1], totalCount, SomaticClusteringModel.indelLength(vc, i))).map(model::probabilityOfSequencingError).collect(Collectors.toList());
    }

    @Override
    public Optional<String> phredScaledPosteriorAnnotationName() {
        return Optional.of("SEQQ");
    }

    @Override
    public String filterName() {
        return "weak_evidence";
    }

    @Override
    protected List<String> requiredInfoAnnotations() {
        return Collections.singletonList("TLOD");
    }
}

