/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.qc;

import htsjdk.samtools.util.Locatable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.LocusWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.codecs.sampileup.SAMPileupFeature;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@DocumentedFeature
@CommandLineProgramProperties(summary="This tool compares the mpileup data (reference base, aligned base from each overlapping read, and quality score) generated internally by GATK to a reference pileup data generated by Samtools, for each position in the requested interval.", oneLineSummary="Compare GATK's internal pileup to a reference Samtools mpileup", programGroup=DiagnosticsAndQCProgramGroup.class)
public final class CheckPileup
extends LocusWalker {
    @Argument(fullName="pileup", doc="Pileup generated by Samtools")
    public FeatureInput<SAMPileupFeature> mpileup;
    @Argument(fullName="output", shortName="O", doc="Output file (if not provided, defaults to STDOUT)", optional=true)
    public File outFile = null;
    @Argument(fullName="ignore-overlaps", doc="Disable read-pair overlap detection", optional=true)
    public boolean ignoreOverlaps = false;
    @Argument(fullName="continue-after-error", doc="Continue after encountering an error", optional=true)
    public boolean continueAfterAnError = false;
    private long nLoci = 0L;
    private long nBases = 0L;
    private PrintStream out;

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        List<ReadFilter> defaultFilters = super.getDefaultReadFilters();
        defaultFilters.add(ReadFilterLibrary.NOT_DUPLICATE);
        defaultFilters.add(ReadFilterLibrary.PASSES_VENDOR_QUALITY_CHECK);
        defaultFilters.add(ReadFilterLibrary.NOT_SECONDARY_ALIGNMENT);
        return defaultFilters;
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public void onTraversalStart() {
        try {
            this.out = this.outFile == null ? System.out : new PrintStream(this.outFile);
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotCreateOutputFile(this.outFile, e.getMessage());
        }
    }

    @Override
    public void apply(AlignmentContext context, ReferenceContext ref, FeatureContext featureContext) {
        ReadPileup pileup = context.getBasePileup();
        SAMPileupFeature truePileup = this.getTruePileup(featureContext);
        if (!this.ignoreOverlaps) {
            pileup.fixOverlaps();
        }
        if (truePileup == null) {
            this.out.printf("No truth pileup data available at %s%n", pileup.getPileupString((char)ref.getBase()));
            if (!this.continueAfterAnError) {
                throw new UserException.BadInput(String.format("No pileup data available at %s given GATK's output of %s -- this walker requires samtools mpileup data over all bases", context.getLocation(), new String(pileup.getBases())));
            }
        } else {
            String pileupDiff = this.pileupDiff(pileup, truePileup);
            if (pileupDiff != null) {
                this.out.printf("%s vs. %s%n", pileup.getPileupString((char)ref.getBase()), truePileup.getPileupString());
                if (!this.continueAfterAnError) {
                    throw new UserException.BadInput(String.format("The input pileup doesn't match the GATK's internal pileup: %s", pileupDiff));
                }
            }
        }
        ++this.nLoci;
        this.nBases += (long)pileup.size();
    }

    public String pileupDiff(ReadPileup a, SAMPileupFeature b) {
        String bQuals;
        if (a.size() != b.size()) {
            return String.format("Sizes not equal: %s vs. %s", a.size(), b.size());
        }
        if (IntervalUtils.compareLocatables(a.getLocation(), (Locatable)b, this.getReferenceDictionary()) != 0) {
            return String.format("Locations not equal: %s vs. %s", a.getLocation(), b);
        }
        String aBases = new String(a.getBases());
        String bBases = b.getBasesString();
        if (!aBases.toUpperCase().equals(bBases.toUpperCase())) {
            return String.format("Bases not equal: %s vs. %s", aBases, bBases);
        }
        String aQuals = new String(a.getBaseQuals());
        if (!aQuals.equals(bQuals = new String(b.getBaseQuals()))) {
            return String.format("Quals not equal: %s vs. %s", aQuals, bQuals);
        }
        return null;
    }

    private SAMPileupFeature getTruePileup(FeatureContext featureContext) {
        List<SAMPileupFeature> features = featureContext.getValues(this.mpileup);
        return features.isEmpty() ? null : features.get(0);
    }

    @Override
    public Object onTraversalSuccess() {
        return String.format("Validated %d sites covered by %d bases%n", this.nLoci, this.nBases);
    }

    @Override
    public void closeTool() {
        this.out.close();
    }
}

