/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.qc;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.tribble.Feature;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CoverageAnalysisProgramGroup;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.LocusWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;

@CommandLineProgramProperties(summary="Prints read alignments in samtools pileup format. The output comprises one line per genomic position, listing the chromosome name, coordinate, reference base, read bases, and read qualities. In addition to these default fields, additional information can be added to the output as extra columns.", oneLineSummary="Prints read alignments in samtools pileup format", programGroup=CoverageAnalysisProgramGroup.class)
@DocumentedFeature
public final class Pileup
extends LocusWalker {
    private static final String VERBOSE_DELIMITER = "@";
    @Argument(fullName="output", shortName="O", doc="An output file created to be created by the walker. Will overwrite the contents if the file exists.")
    public File outFile;
    @Argument(fullName="show-verbose", shortName="verbose", doc="Add extra informative columns to the pileup output. The verbose output contains the number of spanning deletions, and for each read in the pileup it has the read name, offset in the base string, read length, and read mapping quality.  These per read items are delimited with an '@' character.", optional=true)
    public boolean showVerbose = false;
    @Argument(fullName="metadata", shortName="metadata", doc="Features file(s) containing metadata. The overlapping sites will be annotated with the corresponding source Feature identifier.", optional=true)
    public List<FeatureInput<Feature>> metadata = new ArrayList<FeatureInput<Feature>>();
    @Argument(fullName="output-insert-length", shortName="output-insert-length", doc="If enabled, inserts lengths will be added to the output pileup.", optional=true)
    public boolean outputInsertLength = false;
    private PrintStream out;

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        List<ReadFilter> defaultFilters = super.getDefaultReadFilters();
        defaultFilters.add(ReadFilterLibrary.NOT_DUPLICATE);
        defaultFilters.add(ReadFilterLibrary.PASSES_VENDOR_QUALITY_CHECK);
        defaultFilters.add(ReadFilterLibrary.NOT_SECONDARY_ALIGNMENT);
        return defaultFilters;
    }

    @Override
    public void onTraversalStart() {
        try {
            this.out = new PrintStream(this.outFile);
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotCreateOutputFile(this.outFile, (Exception)e);
        }
    }

    @Override
    public void apply(AlignmentContext alignmentContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        String features = this.getFeaturesString(featureContext);
        ReadPileup basePileup = alignmentContext.getBasePileup().makeFilteredPileup(pe -> !pe.isDeletion());
        StringBuilder s = new StringBuilder();
        s.append(String.format("%s %s", basePileup.getPileupString(this.hasReference() ? (char)referenceContext.getBase() : (char)'N'), features));
        if (this.outputInsertLength) {
            s.append(" ").append(Pileup.insertLengthOutput(basePileup));
        }
        if (this.showVerbose) {
            s.append(" ").append(Pileup.createVerboseOutput(basePileup));
        }
        s.append("\n");
        this.out.print(s.toString());
    }

    private String getFeaturesString(FeatureContext featureContext) {
        String featuresString = featureContext.getValues(this.metadata).stream().map(Object::toString).collect(Collectors.joining(", "));
        if (!featuresString.isEmpty()) {
            featuresString = "[Feature(s): " + featuresString + "]";
        }
        return featuresString;
    }

    @VisibleForTesting
    static String insertLengthOutput(ReadPileup pileup) {
        return pileup.getReads().stream().map(r -> String.valueOf(r.getFragmentLength())).collect(Collectors.joining(","));
    }

    @VisibleForTesting
    static String createVerboseOutput(ReadPileup pileup) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        sb.append(pileup.getNumberOfElements(PileupElement::isDeletion));
        sb.append(" ");
        for (PileupElement p : pileup) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(p.getRead().getName());
            sb.append(VERBOSE_DELIMITER);
            sb.append(p.getOffset());
            sb.append(VERBOSE_DELIMITER);
            sb.append(p.getRead().getLength());
            sb.append(VERBOSE_DELIMITER);
            sb.append(p.getRead().getMappingQuality());
        }
        return sb.toString();
    }

    @Override
    public void closeTool() {
        if (this.out != null) {
            this.out.close();
        }
    }
}

