/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.readorientation;

import htsjdk.samtools.util.SequenceUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.readorientation.F1R2FilterConstants;
import org.broadinstitute.hellbender.utils.Nucleotide;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableReader;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public class AltSiteRecord {
    private String referenceContext;
    private int refCount;
    private int altCount;
    private int refF1R2;
    private int altF1R2;
    private int depth;
    private Nucleotide altAllele;

    public AltSiteRecord(String referenceContext, int refCount, int altCount, int refF1R2, int altF1R2, Nucleotide altAllele) {
        Utils.validateArg(altAllele != null && altAllele.isStandard(), "altAllele must be one of {A,C,G,T} but got " + (Object)((Object)altAllele));
        this.referenceContext = referenceContext;
        this.refCount = refCount;
        this.altCount = altCount;
        this.refF1R2 = refF1R2;
        this.altF1R2 = altF1R2;
        this.depth = refCount + altCount;
        this.altAllele = altAllele;
    }

    public String getReferenceContext() {
        return this.referenceContext;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public int getAltCount() {
        return this.altCount;
    }

    public int getRefF1R2() {
        return this.refF1R2;
    }

    public int getAltF1R2() {
        return this.altF1R2;
    }

    public int getDepth() {
        return this.depth;
    }

    public Nucleotide getAltAllele() {
        return this.altAllele;
    }

    public AltSiteRecord getReverseComplementOfRecord() {
        Utils.validate(!F1R2FilterConstants.CANONICAL_KMERS.contains(this.referenceContext), "for consistency, don't make the revcomp record of a canonical reference context");
        Nucleotide revCompOfAlt = this.altAllele.complement();
        int newRefF1R2 = this.refCount - this.refF1R2;
        int newAltF1R2 = this.altCount - this.altF1R2;
        return new AltSiteRecord(SequenceUtil.reverseComplement((String)this.referenceContext), this.refCount, this.altCount, newRefF1R2, newAltF1R2, revCompOfAlt);
    }

    public static Pair<String, List<AltSiteRecord>> readAltSiteRecords(Path table, int initialListSize) {
        String sample;
        ArrayList records = new ArrayList(initialListSize);
        try (AltSiteRecordTableReader reader = new AltSiteRecordTableReader(table);){
            sample = reader.getMetadata().get("SAMPLE");
            reader.forEach(records::add);
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while reading from %s.", table), e);
        }
        return ImmutablePair.of((Object)sample, records);
    }

    public static Pair<String, List<AltSiteRecord>> readAltSiteRecords(Path table) {
        return AltSiteRecord.readAltSiteRecords(table, 100);
    }

    private static class AltSiteRecordTableReader
    extends TableReader<AltSiteRecord> {
        private AltSiteRecordTableReader(Path table) throws IOException {
            super(table);
        }

        @Override
        protected AltSiteRecord createRecord(DataLine dataLine) {
            String referenceContext = dataLine.get(AltSiteRecordTableColumn.CONTEXT);
            int refCount = Integer.parseInt(dataLine.get(AltSiteRecordTableColumn.REF_COUNT));
            int altCount = Integer.parseInt(dataLine.get(AltSiteRecordTableColumn.ALT_COUNT));
            int refF1R2 = Integer.parseInt(dataLine.get(AltSiteRecordTableColumn.REF_F1R2));
            int altF1R2 = Integer.parseInt(dataLine.get(AltSiteRecordTableColumn.ALT_F1R2));
            int depth = Integer.parseInt(dataLine.get(AltSiteRecordTableColumn.DEPTH));
            Nucleotide altAllele = Nucleotide.valueOf(dataLine.get(AltSiteRecordTableColumn.ALT_BASE));
            return new AltSiteRecord(referenceContext, refCount, altCount, refF1R2, altF1R2, altAllele);
        }
    }

    public static class AltSiteRecordTableWriter
    extends TableWriter<AltSiteRecord> {
        public AltSiteRecordTableWriter(Path output, String sample) throws IOException {
            super(output, AltSiteRecordTableColumn.COLUMNS);
            this.writeMetadata("SAMPLE", sample);
        }

        @Override
        protected void composeLine(AltSiteRecord record, DataLine dataLine) {
            dataLine.set(AltSiteRecordTableColumn.CONTEXT.toString(), record.getReferenceContext()).set(AltSiteRecordTableColumn.REF_COUNT.toString(), record.getRefCount()).set(AltSiteRecordTableColumn.ALT_COUNT.toString(), record.getAltCount()).set(AltSiteRecordTableColumn.REF_F1R2.toString(), record.getRefF1R2()).set(AltSiteRecordTableColumn.ALT_F1R2.toString(), record.getAltF1R2()).set(AltSiteRecordTableColumn.DEPTH.toString(), record.getDepth()).set(AltSiteRecordTableColumn.ALT_BASE.toString(), record.getAltAllele().toString());
        }
    }

    private static enum AltSiteRecordTableColumn {
        CONTEXT("context"),
        REF_COUNT("ref_count"),
        ALT_COUNT("alt_count"),
        REF_F1R2("ref_f1r2"),
        ALT_F1R2("alt_f1r2"),
        DEPTH("depth"),
        ALT_BASE("alt");

        private String columnName;
        public static final TableColumnCollection COLUMNS;

        private AltSiteRecordTableColumn(String columnName) {
            this.columnName = columnName;
        }

        public String toString() {
            return this.columnName;
        }

        static {
            COLUMNS = new TableColumnCollection((Object[])AltSiteRecordTableColumn.values());
        }
    }
}

