/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.readorientation;

import htsjdk.samtools.util.SequenceUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.walkers.readorientation.ArtifactState;
import org.broadinstitute.hellbender.tools.walkers.readorientation.F1R2FilterConstants;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableReader;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public class ArtifactPrior {
    private final String referenceContext;
    private final double[] pi;
    private final int numExamples;
    private final int numAltExamples;

    public ArtifactPrior(String referenceContext, double[] pi, int numExamples, int numAltExamples) {
        this.referenceContext = referenceContext;
        this.pi = pi;
        this.numExamples = numExamples;
        this.numAltExamples = numAltExamples;
    }

    public double getPi(ArtifactState state) {
        return this.pi[state.ordinal()];
    }

    public double[] getPi() {
        return this.pi;
    }

    public String getReferenceContext() {
        return this.referenceContext;
    }

    public String getRCContext() {
        return SequenceUtil.reverseComplement((String)this.referenceContext);
    }

    public ArtifactPrior getReverseComplement() {
        double[] revCompPi = new double[F1R2FilterConstants.NUM_STATES];
        String revCompRefContext = SequenceUtil.reverseComplement((String)this.referenceContext);
        for (ArtifactState s : ArtifactState.values()) {
            revCompPi[s.ordinal()] = this.pi[s.getRevCompState().ordinal()];
        }
        return new ArtifactPrior(revCompRefContext, revCompPi, this.numExamples, this.numAltExamples);
    }

    public int getNumExamples() {
        return this.numExamples;
    }

    public int getNumAltExamples() {
        return this.numAltExamples;
    }

    private static enum ArtifactPriorTableColumn {
        CONTEXT("context"),
        REV_COMP("rev_comp"),
        F1R2_A("f1r2_a", ArtifactState.F1R2_A),
        F1R2_C("f1r2_c", ArtifactState.F1R2_C),
        F1R2_G("f1r2_g", ArtifactState.F1R2_G),
        F1R2_T("f1r2_t", ArtifactState.F1R2_T),
        F2R1_A("f2r1_a", ArtifactState.F2R1_A),
        F2R1_C("f2r1_c", ArtifactState.F2R1_C),
        F2R1_G("f2r1_g", ArtifactState.F2R1_G),
        F2R1_T("f2r1_t", ArtifactState.F2R1_T),
        HOM_REF("hom_ref", ArtifactState.HOM_REF),
        GERMLINE_HET("germline_het", ArtifactState.GERMLINE_HET),
        SOMATIC_HET("somatic_het", ArtifactState.SOMATIC_HET),
        HOM_VAR("hom_var", ArtifactState.HOM_VAR),
        N("num_examples"),
        N_ALT("num_alt_examples");

        private String columnName;
        private ArtifactState state;
        public static final TableColumnCollection COLUMNS;

        private ArtifactPriorTableColumn(String columnName) {
            this.columnName = columnName;
        }

        private ArtifactPriorTableColumn(String columnName, ArtifactState state) {
            this.columnName = columnName;
            this.state = state;
        }

        public String toString() {
            return this.columnName;
        }

        public ArtifactState getState() {
            return this.state;
        }

        public static List<ArtifactPriorTableColumn> getArtifactStateColumns() {
            List<ArtifactPriorTableColumn> nonArtifactColumns = Arrays.asList(CONTEXT, REV_COMP, N, N_ALT);
            return Arrays.stream(ArtifactPriorTableColumn.values()).filter(column -> !nonArtifactColumns.contains(column)).collect(Collectors.toList());
        }

        static {
            COLUMNS = new TableColumnCollection((Object[])ArtifactPriorTableColumn.values());
        }
    }

    public static class ArtifactPriorTableReader
    extends TableReader<ArtifactPrior> {
        public ArtifactPriorTableReader(Path table) throws IOException {
            super(table);
        }

        @Override
        protected ArtifactPrior createRecord(DataLine dataLine) {
            String referenceContext = dataLine.get(ArtifactPriorTableColumn.CONTEXT);
            double[] pi = new double[ArtifactState.values().length];
            for (ArtifactPriorTableColumn column : ArtifactPriorTableColumn.getArtifactStateColumns()) {
                pi[column.getState().ordinal()] = Double.valueOf(dataLine.get(column));
            }
            int numExamples = Integer.parseInt(dataLine.get(ArtifactPriorTableColumn.N));
            int numAltExamples = Integer.parseInt(dataLine.get(ArtifactPriorTableColumn.N_ALT));
            return new ArtifactPrior(referenceContext, pi, numExamples, numAltExamples);
        }
    }

    public static class ArtifactPriorTableWriter
    extends TableWriter<ArtifactPrior> {
        public ArtifactPriorTableWriter(Path output, String sample) throws IOException {
            super(output, ArtifactPriorTableColumn.COLUMNS);
            this.writeMetadata("SAMPLE", sample);
        }

        @Override
        protected void composeLine(ArtifactPrior artifactPrior, DataLine dataLine) {
            dataLine.set(ArtifactPriorTableColumn.CONTEXT.toString(), artifactPrior.getReferenceContext()).set(ArtifactPriorTableColumn.REV_COMP.toString(), artifactPrior.getRCContext()).set(ArtifactPriorTableColumn.F1R2_A.toString(), artifactPrior.getPi(ArtifactState.F1R2_A)).set(ArtifactPriorTableColumn.F1R2_C.toString(), artifactPrior.getPi(ArtifactState.F1R2_C)).set(ArtifactPriorTableColumn.F1R2_G.toString(), artifactPrior.getPi(ArtifactState.F1R2_G)).set(ArtifactPriorTableColumn.F1R2_T.toString(), artifactPrior.getPi(ArtifactState.F1R2_T)).set(ArtifactPriorTableColumn.F2R1_A.toString(), artifactPrior.getPi(ArtifactState.F2R1_A)).set(ArtifactPriorTableColumn.F2R1_C.toString(), artifactPrior.getPi(ArtifactState.F2R1_C)).set(ArtifactPriorTableColumn.F2R1_G.toString(), artifactPrior.getPi(ArtifactState.F2R1_G)).set(ArtifactPriorTableColumn.F2R1_T.toString(), artifactPrior.getPi(ArtifactState.F2R1_T)).set(ArtifactPriorTableColumn.HOM_REF.toString(), artifactPrior.getPi(ArtifactState.HOM_REF)).set(ArtifactPriorTableColumn.GERMLINE_HET.toString(), artifactPrior.getPi(ArtifactState.GERMLINE_HET)).set(ArtifactPriorTableColumn.SOMATIC_HET.toString(), artifactPrior.getPi(ArtifactState.SOMATIC_HET)).set(ArtifactPriorTableColumn.HOM_VAR.toString(), artifactPrior.getPi(ArtifactState.HOM_VAR)).set(ArtifactPriorTableColumn.N.toString(), artifactPrior.getNumExamples()).set(ArtifactPriorTableColumn.N_ALT.toString(), artifactPrior.getNumAltExamples());
        }
    }
}

