/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.readorientation;

import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.readorientation.ArtifactPrior;
import org.broadinstitute.hellbender.tools.walkers.readorientation.F1R2FilterConstants;
import org.broadinstitute.hellbender.tools.walkers.readorientation.F1R2FilterUtils;
import org.broadinstitute.hellbender.tools.walkers.readorientation.LearnReadOrientationModelEngine;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;

public class ArtifactPriorCollection {
    final String sample;
    private final Map<String, ArtifactPrior> map = new HashMap<String, ArtifactPrior>(F1R2FilterConstants.NUM_KMERS);

    public ArtifactPriorCollection(String sample) {
        this.sample = sample;
        for (String kmer : F1R2FilterConstants.ALL_KMERS) {
            this.map.put(kmer, new ArtifactPrior(kmer, LearnReadOrientationModelEngine.getFlatPrior(F1R2FilterUtils.getMiddleBase(kmer)), 0, 0));
        }
    }

    public String getSample() {
        return this.sample;
    }

    public Optional<ArtifactPrior> get(String refContext) {
        if (this.map.containsKey(refContext)) {
            return Optional.of(this.map.get(refContext));
        }
        return Optional.empty();
    }

    public void set(ArtifactPrior artifactPrior) {
        String refContext = artifactPrior.getReferenceContext();
        Utils.validate(this.map.get(refContext).getNumExamples() == 0, "updating an existing ArtifactPrior is not allowed. Ref context = " + refContext);
        Utils.validate(F1R2FilterConstants.CANONICAL_KMERS.contains(refContext), "set must be called on an artifactPrior object with a canonical representation");
        this.map.put(refContext, artifactPrior);
        String revCompRefContext = SequenceUtil.reverseComplement((String)refContext);
        ArtifactPrior revCompArtifactPrior = artifactPrior.getReverseComplement();
        this.map.put(revCompRefContext, revCompArtifactPrior);
    }

    public void writeArtifactPriors(File output) {
        ArrayList<ArtifactPrior> priors = new ArrayList<ArtifactPrior>(this.map.values());
        try (ArtifactPrior.ArtifactPriorTableWriter writer = new ArtifactPrior.ArtifactPriorTableWriter(IOUtils.fileToPath(output), this.sample);){
            writer.writeAllRecords(priors);
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while writing to %s.", output), e);
        }
    }

    public static ArtifactPriorCollection readArtifactPriors(File input) {
        String sample;
        List priors;
        try {
            ArtifactPrior.ArtifactPriorTableReader reader = new ArtifactPrior.ArtifactPriorTableReader(IOUtils.fileToPath(input));
            Object object = null;
            try {
                priors = reader.toList();
                sample = reader.getMetadata().get("SAMPLE");
                if (priors.size() != F1R2FilterConstants.NUM_KMERS) {
                    Utils.warnUser("Reading from a prior table that was not created by ArtifactPriorCollection::writeArtifactPriors");
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while reading from %s.", input), e);
        }
        ArtifactPriorCollection artifactPriorCollection = new ArtifactPriorCollection(sample);
        for (String refContext : F1R2FilterConstants.CANONICAL_KMERS) {
            Optional<ArtifactPrior> ap = priors.stream().filter(a -> a.getReferenceContext().equals(refContext)).findAny();
            if (!ap.isPresent()) {
                throw new UserException.BadInput("ArtifactPrior object isn't present for reference context " + refContext + "in file " + input);
            }
            artifactPriorCollection.set(ap.get());
        }
        return artifactPriorCollection;
    }

    public int getNumUniqueContexts() {
        return (int)this.map.values().stream().filter(a -> a.getNumExamples() > 0).count() / 2;
    }
}

