/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.readorientation;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Nucleotide;

public enum ArtifactState {
    F1R2_A("F2R1_T", Nucleotide.A),
    F1R2_C("F2R1_G", Nucleotide.C),
    F1R2_G("F2R1_C", Nucleotide.G),
    F1R2_T("F2R1_A", Nucleotide.T),
    F2R1_A("F1R2_T", Nucleotide.A),
    F2R1_C("F1R2_G", Nucleotide.C),
    F2R1_G("F1R2_C", Nucleotide.G),
    F2R1_T("F1R2_A", Nucleotide.T),
    HOM_REF("HOM_REF", Nucleotide.INVALID),
    GERMLINE_HET("GERMLINE_HET", Nucleotide.INVALID),
    SOMATIC_HET("SOMATIC_HET", Nucleotide.INVALID),
    HOM_VAR("HOM_VAR", Nucleotide.INVALID);

    private final String reverseComplementState;
    private final Nucleotide altAllele;
    static List<ArtifactState> artifactStates;

    private ArtifactState(String reverseComplementState, Nucleotide altAllele) {
        this.reverseComplementState = reverseComplementState;
        this.altAllele = altAllele;
    }

    public static List<ArtifactState> getStates() {
        return Arrays.stream(ArtifactState.values()).collect(Collectors.toList());
    }

    static List<ArtifactState> getF1R2ArtifactStates() {
        return Arrays.asList(F1R2_A, F1R2_C, F1R2_G, F1R2_T);
    }

    static List<ArtifactState> getF2R1ArtifactStates() {
        return Arrays.asList(F2R1_A, F2R1_C, F2R1_G, F2R1_T);
    }

    public static List<ArtifactState> getNonArtifactStates() {
        return Arrays.asList(HOM_REF, GERMLINE_HET, SOMATIC_HET, HOM_VAR);
    }

    public static List<ArtifactState> getRefToRefArtifacts(Nucleotide refAllele) {
        switch (refAllele) {
            case A: {
                return Arrays.asList(F1R2_A, F2R1_A);
            }
            case C: {
                return Arrays.asList(F1R2_C, F2R1_C);
            }
            case G: {
                return Arrays.asList(F1R2_G, F2R1_G);
            }
            case T: {
                return Arrays.asList(F1R2_T, F2R1_T);
            }
        }
        throw new UserException(String.format("Invalid nucleotide given: %s", new Object[]{refAllele}));
    }

    public Nucleotide getAltAlleleOfArtifact() {
        return this.altAllele;
    }

    public ArtifactState getRevCompState() {
        return ArtifactState.valueOf(this.reverseComplementState);
    }

    public static ArtifactState getF1R2StateForAlt(Nucleotide altAllele) {
        switch (altAllele) {
            case A: {
                return F1R2_A;
            }
            case C: {
                return F1R2_C;
            }
            case G: {
                return F1R2_G;
            }
            case T: {
                return F1R2_T;
            }
        }
        throw new UserException(String.format("Alt allele must be in {A, C, G, T} but got %s", new Object[]{altAllele}));
    }

    public static ArtifactState getF2R1StateForAlt(Nucleotide altAllele) {
        switch (altAllele) {
            case A: {
                return F2R1_A;
            }
            case C: {
                return F2R1_C;
            }
            case G: {
                return F2R1_G;
            }
            case T: {
                return F2R1_T;
            }
        }
        throw new UserException(String.format("Alt allele must be in {A, C, G, T} but got %s", new Object[]{altAllele}));
    }

    public static void setStatePrior(double[] prior, double probability, ArtifactState state) {
        prior[state.ordinal()] = probability;
    }

    static {
        artifactStates = Arrays.asList(F1R2_A, F1R2_C, F1R2_G, F1R2_T, F2R1_A, F2R1_C, F2R1_G, F2R1_T);
    }
}

