/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.readorientation;

import java.io.File;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.CoverageAnalysisProgramGroup;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.LocusWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.tools.walkers.mutect.Mutect2Engine;
import org.broadinstitute.hellbender.tools.walkers.readorientation.CollectF1R2CountsArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.readorientation.F1R2CountsCollector;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

@CommandLineProgramProperties(summary="Collect F1R2 read counts for the Mutect2 orientation bias mixture model filter", oneLineSummary="Collect F1R2 read counts for the Mutect2 orientation bias mixture model filter", programGroup=CoverageAnalysisProgramGroup.class)
public class CollectF1R2Counts
extends LocusWalker {
    @ArgumentCollection
    protected CollectF1R2CountsArgumentCollection CF1R2Args = new CollectF1R2CountsArgumentCollection();
    @Argument(fullName="output", shortName="O", doc="Output .tar.gz file")
    private File outputTarGzFile;
    private F1R2CountsCollector f1R2CountsCollector;

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Mutect2Engine.makeStandardMutect2ReadFilters();
    }

    @Override
    public void onTraversalStart() {
        this.f1R2CountsCollector = new F1R2CountsCollector(this.CF1R2Args, this.getHeaderForReads(), this.outputTarGzFile, ReadUtils.getSamplesFromHeader(this.getHeaderForReads()));
    }

    @Override
    public void apply(AlignmentContext alignmentContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.f1R2CountsCollector.process(alignmentContext.getBasePileup(), referenceContext);
    }

    @Override
    public Object onTraversalSuccess() {
        this.f1R2CountsCollector.writeHistograms();
        return "SUCCESS";
    }

    @Override
    public void closeTool() {
        this.f1R2CountsCollector.closeAndArchiveFiles();
    }
}

