/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.readorientation;

import htsjdk.samtools.util.Histogram;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.tools.walkers.readorientation.F1R2FilterConstants;
import org.broadinstitute.hellbender.tools.walkers.readorientation.F1R2FilterUtils;
import org.broadinstitute.hellbender.tools.walkers.readorientation.ReadOrientation;
import org.broadinstitute.hellbender.utils.Nucleotide;

public class DepthOneHistograms {
    private final Map<String, Map<Pair<Nucleotide, ReadOrientation>, Histogram<Integer>>> map;
    private final int maxDepth;

    public DepthOneHistograms(int maxDepth) {
        this.maxDepth = maxDepth;
        this.map = new HashMap<String, Map<Pair<Nucleotide, ReadOrientation>, Histogram<Integer>>>(F1R2FilterConstants.NUM_KMERS);
        F1R2FilterConstants.ALL_KMERS.forEach(context -> {
            this.map.put((String)context, new HashMap((Nucleotide.STANDARD_BASES.size() - 1) * ReadOrientation.SIZE));
            for (Nucleotide altAllele : Nucleotide.STANDARD_BASES) {
                if (altAllele == F1R2FilterUtils.getMiddleBase(context)) continue;
                for (ReadOrientation artifactType : ReadOrientation.values()) {
                    this.map.get(context).put((Pair<Nucleotide, ReadOrientation>)new ImmutablePair((Object)altAllele, (Object)artifactType), F1R2FilterUtils.createAltHistogram(context, altAllele, artifactType, maxDepth));
                }
            }
        });
    }

    public Histogram<Integer> get(String referenceContext, Nucleotide altAllele, ReadOrientation orientation) {
        ImmutablePair key = new ImmutablePair((Object)altAllele, (Object)orientation);
        return this.map.get(referenceContext).get(key);
    }

    public void increment(String referenceContext, Nucleotide altAllele, ReadOrientation orientation, int depth) {
        int cappedDepth = Math.min(depth, this.maxDepth);
        this.map.get(referenceContext).get(new ImmutablePair((Object)altAllele, (Object)orientation)).increment((Comparable)Integer.valueOf(cappedDepth));
    }

    public List<Histogram<Integer>> getHistograms() {
        return this.map.values().stream().flatMap(s -> s.values().stream()).collect(Collectors.toList());
    }
}

