/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.readorientation;

import htsjdk.samtools.util.SequenceUtil;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.tools.walkers.readorientation.ArtifactState;
import org.broadinstitute.hellbender.tools.walkers.readorientation.ReadOrientation;
import org.broadinstitute.hellbender.utils.Nucleotide;

public class F1R2FilterConstants {
    public static final int REF_CONTEXT_PADDING = 1;
    public static final int NUM_STATES = ArtifactState.values().length;
    static final int MIDDLE_INDEX = 1;
    static final int REFERENCE_CONTEXT_SIZE = 3;
    public static final List<String> ALL_KMERS = SequenceUtil.generateAllKmers((int)3).stream().map(String::new).collect(Collectors.toList());
    public static final int NUM_KMERS = ALL_KMERS.size();
    static final List<String> CANONICAL_KMERS = ALL_KMERS.stream().map(context -> new TreeSet<String>(Arrays.asList(context, SequenceUtil.reverseComplement((String)context)))).distinct().map(s -> ((String)s.first()).compareTo((String)s.last()) < 0 ? (String)s.first() : (String)s.last()).collect(Collectors.toList());
    static final String FIELD_SEPARATOR = "_";
    static final String binName = "depth";
    static final int DEFAULT_MAX_DEPTH = 200;
    static final int numAltHistogramsPerContext = (Nucleotide.STANDARD_BASES.size() - 1) * ReadOrientation.values().length;

    public static Integer[] getEmptyBins(int maxDepth) {
        return (Integer[])IntStream.rangeClosed(1, maxDepth).boxed().toArray(Integer[]::new);
    }
}

