/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.readorientation;

import htsjdk.samtools.util.Histogram;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.broadinstitute.hellbender.tools.walkers.readorientation.F1R2FilterConstants;
import org.broadinstitute.hellbender.tools.walkers.readorientation.ReadOrientation;
import org.broadinstitute.hellbender.utils.Nucleotide;
import org.broadinstitute.hellbender.utils.Utils;

public class F1R2FilterUtils {
    static Histogram<Integer> createAltHistogram(String refContext, Nucleotide altAllele, ReadOrientation type, int maxDepth) {
        Histogram h = new Histogram("depth", F1R2FilterUtils.tripletToLabel(refContext, altAllele, type));
        h.prefillBins((Comparable[])F1R2FilterConstants.getEmptyBins(maxDepth));
        return h;
    }

    static Histogram<Integer> createRefHistogram(String refContext, int maxDepth) {
        Histogram h = new Histogram("depth", refContext);
        h.prefillBins((Comparable[])F1R2FilterConstants.getEmptyBins(maxDepth));
        return h;
    }

    static Triple<String, Nucleotide, ReadOrientation> labelToTriplet(String label) {
        String[] parts = label.split("_");
        Utils.validate(parts.length == 3, "Invalid label: " + label);
        return new ImmutableTriple((Object)parts[0], (Object)Nucleotide.valueOf(parts[1]), (Object)ReadOrientation.valueOf(parts[2]));
    }

    static String tripletToLabel(String context, Nucleotide altAllele, ReadOrientation type) {
        return String.join((CharSequence)"_", context, altAllele.toString(), type.toString());
    }

    public static Nucleotide getMiddleBase(String refContext) {
        return Nucleotide.valueOf(refContext.substring(1, 2));
    }
}

