/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.realignmentfilter;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFlag;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.tools.spark.sv.utils.Strand;
import org.broadinstitute.hellbender.tools.walkers.realignmentfilter.RealignmentArgumentCollection;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.bwa.BwaMemAligner;
import org.broadinstitute.hellbender.utils.bwa.BwaMemAlignment;
import org.broadinstitute.hellbender.utils.bwa.BwaMemIndex;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public class RealignmentEngine {
    private final BwaMemAligner aligner;
    private final int numberOfRegularContigs;

    public RealignmentEngine(RealignmentArgumentCollection rfac) {
        BwaMemIndex index = new BwaMemIndex(rfac.bwaMemIndexImage);
        this.numberOfRegularContigs = rfac.numRegularContigs;
        this.aligner = new BwaMemAligner(index);
        this.aligner.setMinSeedLengthOption(rfac.minSeedLength);
        this.aligner.setDropRatioOption((float)rfac.dropRatio);
        this.aligner.setSplitFactorOption((float)rfac.splitFactor);
        this.aligner.setFlagOption(8);
    }

    public static boolean supportsVariant(GATKRead read, VariantContext vc, int indelStartTolerance) {
        byte[] readBases = read.getBasesNoCopy();
        Pair<Integer, CigarOperator> offsetAndOperatorInRead = ReadUtils.getReadIndexForReferenceCoordinate(read, vc.getStart());
        if ((Integer)offsetAndOperatorInRead.getLeft() == -1) {
            return false;
        }
        if (vc.isSNP() && offsetAndOperatorInRead.getRight() == CigarOperator.DELETION) {
            return false;
        }
        int variantPositionInRead = (Integer)offsetAndOperatorInRead.getLeft();
        for (Allele allele : vc.getAlternateAlleles()) {
            int referenceLength = vc.getReference().length();
            if (allele.length() == referenceLength) {
                if (!allele.basesMatch(ArrayUtils.subarray((byte[])readBases, (int)variantPositionInRead, (int)Math.min(variantPositionInRead + allele.length(), readBases.length)))) continue;
                return true;
            }
            boolean isDeletion = allele.length() < referenceLength;
            int readPosition = 0;
            for (CigarElement cigarElement : read.getCigarElements()) {
                if (Math.abs(readPosition - variantPositionInRead) <= indelStartTolerance) {
                    if ((!isDeletion || !RealignmentEngine.mightSupportDeletion(cigarElement)) && (isDeletion || !RealignmentEngine.mightSupportInsertion(cigarElement))) continue;
                    return true;
                }
                readPosition += cigarElement.getLength();
            }
        }
        return false;
    }

    private static boolean mightSupportDeletion(CigarElement cigarElement) {
        CigarOperator cigarOperator = cigarElement.getOperator();
        return cigarOperator == CigarOperator.D || cigarOperator == CigarOperator.S;
    }

    private static final boolean mightSupportInsertion(CigarElement cigarElement) {
        CigarOperator cigarOperator = cigarElement.getOperator();
        return cigarOperator == CigarOperator.I || cigarOperator == CigarOperator.S;
    }

    public List<BwaMemAlignment> realign(byte[] sequence) {
        List<BwaMemAlignment> alignments = ((List)this.aligner.alignSeqs(Arrays.asList(new byte[][]{sequence})).get(0)).stream().filter(a -> a.getRefId() >= 0).collect(Collectors.toList());
        return alignments.size() == 1 ? alignments : alignments.stream().filter(a -> a.getRefId() < this.numberOfRegularContigs).collect(Collectors.toList());
    }

    public static List<List<BwaMemAlignment>> findJointAlignments(List<List<BwaMemAlignment>> allUnitigAlignments, int maxReasonableFragmentLength) {
        if (allUnitigAlignments.isEmpty()) {
            return Collections.emptyList();
        }
        if (allUnitigAlignments.size() == 1) {
            return allUnitigAlignments.get(0).stream().map(Collections::singletonList).collect(Collectors.toList());
        }
        Collections.sort(allUnitigAlignments, Comparator.comparingInt(List::size));
        ArrayList<OverlapDetector> overlapDetectors = new ArrayList<OverlapDetector>();
        for (List<BwaMemAlignment> unitigAlignments : allUnitigAlignments) {
            List intervals = unitigAlignments.stream().map(RealignmentEngine::convertToInterval).collect(Collectors.toList());
            OverlapDetector overlapDetector = new OverlapDetector(-maxReasonableFragmentLength / 2, -maxReasonableFragmentLength / 2);
            overlapDetector.addAll(unitigAlignments, intervals);
            overlapDetectors.add(overlapDetector);
        }
        HashSet commonAlignments = new HashSet();
        for (BwaMemAlignment alignment : allUnitigAlignments.get(0)) {
            Strand strand = RealignmentEngine.getStrand(alignment);
            SimpleInterval interval = RealignmentEngine.convertToInterval(alignment);
            if (!overlapDetectors.stream().allMatch(detector -> detector.getOverlaps((Locatable)interval).stream().anyMatch(a -> RealignmentEngine.getStrand(a) == strand))) continue;
            List alignments = overlapDetectors.stream().map(detector -> detector.getOverlaps((Locatable)interval).stream().filter(a -> RealignmentEngine.getStrand(a) == strand).max(Comparator.comparingInt(BwaMemAlignment::getAlignerScore)).get()).collect(Collectors.toList());
            commonAlignments.add(alignments);
        }
        return new ArrayList<List<BwaMemAlignment>>(commonAlignments);
    }

    private static SimpleInterval convertToInterval(BwaMemAlignment alignment) {
        return new SimpleInterval(Integer.toString(alignment.getRefId()), alignment.getRefStart() + 1, alignment.getRefEnd());
    }

    private static Strand getStrand(BwaMemAlignment alignment) {
        return SAMFlag.READ_REVERSE_STRAND.isSet(alignment.getSamFlag()) ? Strand.NEGATIVE : Strand.POSITIVE;
    }
}

