/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.rnaseq;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.CoverageAnalysisProgramGroup;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.LocusWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;

@DocumentedFeature
@CommandLineProgramProperties(summary="Counts filtered reads at het sites for allele specific expression estimate", oneLineSummary="Generates table of filtered base counts at het sites for allele specific expression", programGroup=CoverageAnalysisProgramGroup.class)
public class ASEReadCounter
extends LocusWalker {
    @Argument(fullName="output", shortName="O", doc="Output file (if not provided, defaults to STDOUT)", optional=true)
    private File outputFile = null;
    @Argument(fullName="variant", shortName="V", doc="One or more VCF files")
    private List<FeatureInput<VariantContext>> variants;
    @Argument(fullName="min-depth-of-non-filtered-base", shortName="min-depth", doc="Minimum number of bases that pass filters", optional=true)
    public int minDepthOfNonFilteredBases = -1;
    @Argument(fullName="min-mapping-quality", shortName="mmq", doc="Minimum read mapping quality", optional=true)
    public int minMappingQuality = 0;
    @Argument(fullName="min-base-quality", shortName="mbq", doc="Minimum base quality", optional=true)
    public byte minBaseQuality = 0;
    @Argument(fullName="count-overlap-reads-handling", shortName="overlap", doc="Handling of overlapping reads from the same fragment", optional=true)
    public CountPileupType countType = CountPileupType.COUNT_FRAGMENTS_REQUIRE_SAME_BASE;
    @Argument(fullName="output-format", doc="Format of the output file", optional=true)
    public OUTPUT_FORMAT outputFormat = OUTPUT_FORMAT.RTABLE;
    public String separator = "\t";
    private PrintStream outputStream = null;

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        ArrayList<ReadFilter> defaultFilters = new ArrayList<ReadFilter>();
        defaultFilters.add(ReadFilterLibrary.VALID_ALIGNMENT_START);
        defaultFilters.add(ReadFilterLibrary.VALID_ALIGNMENT_END);
        defaultFilters.add(ReadFilterLibrary.HAS_READ_GROUP);
        defaultFilters.add(ReadFilterLibrary.HAS_MATCHING_BASES_AND_QUALS);
        defaultFilters.add(ReadFilterLibrary.SEQ_IS_STORED);
        defaultFilters.add(ReadFilterLibrary.NOT_DUPLICATE);
        defaultFilters.add(ReadFilterLibrary.NOT_SECONDARY_ALIGNMENT);
        defaultFilters.add(new ReadFilterLibrary.MappedReadFilter());
        return defaultFilters;
    }

    @Override
    public void onTraversalStart() {
        try {
            this.outputStream = this.outputFile != null ? new PrintStream(this.outputFile) : System.out;
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotCreateOutputFile(this.outputFile, (Exception)e);
        }
        if (this.outputFormat.equals((Object)OUTPUT_FORMAT.CSV)) {
            this.separator = ",";
        }
        String header = "contig" + this.separator + "position" + this.separator + "variantID" + this.separator + "refAllele" + this.separator + "altAllele" + this.separator + "refCount" + this.separator + "altCount" + this.separator + "totalCount" + this.separator + "lowMAPQDepth" + this.separator + "lowBaseQDepth" + this.separator + "rawDepth" + this.separator + "otherBases" + this.separator + "improperPairs";
        this.outputStream.println(header);
    }

    @Override
    public void apply(AlignmentContext alignmentContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        String contig = alignmentContext.getContig();
        long position = alignmentContext.getPosition();
        char refAllele = (char)referenceContext.getBase();
        List VCs = featureContext.getValues(this.variants);
        if (VCs != null && VCs.size() > 1) {
            throw new UserException("More then one variant context at position: " + contig + ":" + position);
        }
        if (VCs == null || VCs.isEmpty()) {
            return;
        }
        VariantContext vc = (VariantContext)VCs.get(0);
        if (!vc.isBiallelic()) {
            this.logger.warn("Ignoring site: cannot run ASE on non-biallelic sites: " + vc.toString());
            return;
        }
        if (vc.getHetCount() < 1) {
            this.logger.warn("Ignoring site: variant is not het at postion: " + contig + ":" + position);
            return;
        }
        if (vc.getNAlleles() == 1 || vc.getAlternateAllele(0).getBases().length == 0) {
            throw new UserException("The file of variant sites must contain heterozygous sites and cannot be a GVCF file containing <NON_REF> alleles.");
        }
        char altAllele = (char)vc.getAlternateAllele(0).getBases()[0];
        String siteID = vc.getID();
        ReadPileup pileup = this.filterPileup(alignmentContext.getBasePileup(), this.countType);
        String line = this.calculateLineForSite(pileup, siteID, refAllele, altAllele);
        if (line != null) {
            this.outputStream.println(line);
        }
    }

    @Override
    public void closeTool() {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    private ReadPileup filterPileup(ReadPileup originalPileup, CountPileupType countType) {
        ReadPileup pileupWithDeletions;
        SAMFileHeader header = this.getHeaderForReads();
        switch (countType) {
            case COUNT_FRAGMENTS_REQUIRE_SAME_BASE: {
                pileupWithDeletions = originalPileup.getOverlappingFragmentFilteredPileup(true, ReadPileup.baseQualTieBreaker, header);
                break;
            }
            case COUNT_READS: {
                pileupWithDeletions = originalPileup;
                break;
            }
            case COUNT_FRAGMENTS: {
                pileupWithDeletions = originalPileup.getOverlappingFragmentFilteredPileup(false, ReadPileup.baseQualTieBreaker, header);
                break;
            }
            default: {
                throw new UserException("Must use valid CountPileupType");
            }
        }
        return pileupWithDeletions.makeFilteredPileup(p -> !p.isDeletion());
    }

    private String calculateLineForSite(ReadPileup pileup, String siteID, char refAllele, char altAllele) {
        int rawDepth = 0;
        int lowBaseQDepth = 0;
        int lowMAPQDepth = 0;
        int refCount = 0;
        int altCount = 0;
        int totalNonFilteredCount = 0;
        int otherBasesCount = 0;
        int improperPairsCount = 0;
        for (PileupElement base : pileup) {
            ++rawDepth;
            if (base.getRead().isPaired() && (base.getRead().mateIsUnmapped() || !base.getRead().isProperlyPaired())) {
                ++improperPairsCount;
                continue;
            }
            if (base.getMappingQual() < this.minMappingQuality) {
                ++lowMAPQDepth;
                continue;
            }
            if (base.getQual() < this.minBaseQuality) {
                ++lowBaseQDepth;
                continue;
            }
            if (base.getBase() == refAllele) {
                ++refCount;
            } else if (base.getBase() == altAllele) {
                ++altCount;
            } else {
                ++otherBasesCount;
                continue;
            }
            ++totalNonFilteredCount;
        }
        if (totalNonFilteredCount < this.minDepthOfNonFilteredBases) {
            return null;
        }
        StringBuilder line = new StringBuilder();
        line.append(pileup.getLocation().getContig()).append(this.separator);
        line.append(pileup.getLocation().getStart()).append(this.separator);
        line.append(siteID).append(this.separator);
        line.append(refAllele).append(this.separator);
        line.append(altAllele).append(this.separator);
        line.append(refCount).append(this.separator);
        line.append(altCount).append(this.separator);
        line.append(totalNonFilteredCount).append(this.separator);
        line.append(lowMAPQDepth).append(this.separator);
        line.append(lowBaseQDepth).append(this.separator);
        line.append(rawDepth).append(this.separator);
        line.append(otherBasesCount).append(this.separator);
        line.append(improperPairsCount);
        return line.toString();
    }

    public static enum CountPileupType {
        COUNT_READS,
        COUNT_FRAGMENTS,
        COUNT_FRAGMENTS_REQUIRE_SAME_BASE;

    }

    public static enum OUTPUT_FORMAT {
        TABLE,
        RTABLE,
        CSV;

    }
}

