/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.rnaseq;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.rnaseq.SplitNCigarReads;
import org.broadinstitute.hellbender.utils.GenomeLoc;
import org.broadinstitute.hellbender.utils.GenomeLocParser;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.clipping.ReadClipper;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.GATKReadWriter;
import org.broadinstitute.hellbender.utils.read.ReadCoordinateComparator;

public class OverhangFixingManager {
    private final Map<String, Tuple<Integer, String>> mateChangedReads;
    protected static final Logger logger = LogManager.getLogger(OverhangFixingManager.class);
    private static final boolean DEBUG = false;
    private final int maxRecordsInMemory;
    private final int maxMismatchesInOverhang;
    private final int maxBasesInOverhang;
    private final boolean doNotFixOverhangs;
    private final boolean processSecondaryReads;
    private boolean outputToFile;
    private final SAMFileHeader header;
    private final GATKReadWriter writer;
    private final ReferenceSequenceFile referenceReader;
    private final GenomeLocParser genomeLocParser;
    private static final int INITIAL_CAPACITY = 5000;
    private final PriorityQueue<List<SplitRead>> waitingReadGroups;
    private int waitingReads;
    private final Set<Splice> splices = new TreeSet<Splice>(new SpliceComparator());
    protected static final int MAX_SPLICES_TO_KEEP = 1000;

    public OverhangFixingManager(SAMFileHeader header, GATKReadWriter writer, GenomeLocParser genomeLocParser, ReferenceSequenceFile referenceReader, int maxRecordsInMemory, int maxMismatchesInOverhangs, int maxBasesInOverhangs, boolean doNotFixOverhangs, boolean processSecondaryReads) {
        this.header = header;
        this.writer = writer;
        this.genomeLocParser = genomeLocParser;
        this.referenceReader = referenceReader;
        this.maxRecordsInMemory = maxRecordsInMemory;
        this.maxMismatchesInOverhang = maxMismatchesInOverhangs;
        this.maxBasesInOverhang = maxBasesInOverhangs;
        this.doNotFixOverhangs = doNotFixOverhangs;
        this.waitingReadGroups = new PriorityQueue<List<SplitRead>>(5000, new SplitReadComparator());
        this.outputToFile = false;
        this.mateChangedReads = new HashMap<String, Tuple<Integer, String>>();
        this.processSecondaryReads = processSecondaryReads;
    }

    final int getNReadsInQueue() {
        return this.waitingReads;
    }

    List<List<SplitRead>> getReadsInQueueForTesting() {
        return new ArrayList<List<SplitRead>>(this.waitingReadGroups);
    }

    public List<Splice> getSplicesForTesting() {
        return new ArrayList<Splice>(this.splices);
    }

    @VisibleForTesting
    public Splice addSplicePosition(String contig, int start, int end) {
        boolean sameContig;
        if (this.doNotFixOverhangs) {
            return null;
        }
        Splice splice = new Splice(contig, start, end);
        if (this.splices.contains(splice)) {
            return null;
        }
        splice.initialize(this.referenceReader);
        boolean bl = sameContig = this.splices.isEmpty() || this.splices.iterator().next().loc.getContig().equals(contig);
        if (!sameContig) {
            this.splices.clear();
        }
        this.waitingReadGroups.parallelStream().forEach(readGroup -> {
            int size = readGroup.size();
            for (int i = 0; i < size; ++i) {
                this.fixSplit((SplitRead)readGroup.get(i), splice);
            }
        });
        this.splices.add(splice);
        if (this.splices.size() > 1000) {
            this.cleanSplices();
        }
        return splice;
    }

    public void addReadGroup(List<GATKRead> readGroup) {
        boolean encounteredNewContig;
        Utils.nonEmpty(readGroup, "readGroup added to manager is empty, which is not allowed");
        boolean tooManyReads = this.getNReadsInQueue() >= this.maxRecordsInMemory;
        GATKRead topRead = this.getNReadsInQueue() > 0 ? this.waitingReadGroups.peek().get((int)0).read : null;
        GATKRead firstNewGroup = readGroup.get(0);
        boolean bl = encounteredNewContig = this.getNReadsInQueue() > 0 && !topRead.isUnmapped() && !firstNewGroup.isUnmapped() && !topRead.getContig().equals(firstNewGroup.getContig());
        if (tooManyReads || encounteredNewContig) {
            int targetQueueSize = encounteredNewContig ? 0 : this.maxRecordsInMemory / 2;
            this.writeReads(targetQueueSize);
        }
        List newReadGroup = readGroup.stream().map(this::getSplitRead).collect(Collectors.toList());
        for (Splice splice : this.splices) {
            for (int i = 0; i < newReadGroup.size(); ++i) {
                this.fixSplit((SplitRead)newReadGroup.get(i), splice);
            }
        }
        this.waitingReadGroups.add(newReadGroup);
        this.waitingReads += newReadGroup.size();
    }

    private void cleanSplices() {
        int targetQueueSize = this.splices.size() / 2;
        Iterator<Splice> iter = this.splices.iterator();
        for (int i = 0; i < targetQueueSize; ++i) {
            iter.next();
            iter.remove();
        }
    }

    @VisibleForTesting
    void fixSplit(SplitRead splitRead, Splice splice) {
        if (splitRead.unclippedLoc == null || !splice.loc.overlapsP(splitRead.unclippedLoc)) {
            return;
        }
        if (!this.processSecondaryReads && splitRead.read.isSecondaryAlignment()) {
            return;
        }
        GenomeLoc readLoc = splitRead.unclippedLoc;
        GATKRead read = splitRead.read;
        int readBasesLength = Utils.stream(read.getCigar().getCigarElements()).filter(c -> c.getOperator().consumesReadBases() && !c.getOperator().isClipping()).mapToInt(CigarElement::getLength).sum();
        if (OverhangFixingManager.isLeftOverhang(readLoc, splice.loc)) {
            int overhang = splice.loc.getStop() - read.getStart() + 1;
            if (this.overhangingBasesMismatch(read.getBases(), read.getStart() - readLoc.getStart(), readBasesLength, splice.reference, splice.reference.length - overhang, overhang)) {
                GATKRead clippedRead = ReadClipper.softClipByReadCoordinates(read, 0, splice.loc.getStop() - readLoc.getStart());
                splitRead.setRead(clippedRead);
            }
        } else if (OverhangFixingManager.isRightOverhang(readLoc, splice.loc)) {
            int overhang = readLoc.getStop() - splice.loc.getStart() + 1;
            if (this.overhangingBasesMismatch(read.getBases(), read.getLength() - overhang, readBasesLength, splice.reference, 0, read.getEnd() - splice.loc.getStart() + 1)) {
                GATKRead clippedRead = ReadClipper.softClipByReadCoordinates(read, read.getLength() - overhang, read.getLength() - 1);
                splitRead.setRead(clippedRead);
            }
        }
    }

    protected static boolean isLeftOverhang(GenomeLoc readLoc, GenomeLoc spliceLoc) {
        return readLoc.getStart() <= spliceLoc.getStop() && readLoc.getStart() > spliceLoc.getStart() && readLoc.getStop() > spliceLoc.getStop();
    }

    protected static boolean isRightOverhang(GenomeLoc readLoc, GenomeLoc spliceLoc) {
        return readLoc.getStop() >= spliceLoc.getStart() && readLoc.getStop() < spliceLoc.getStop() && readLoc.getStart() < spliceLoc.getStart();
    }

    protected boolean overhangingBasesMismatch(byte[] read, int readStartIndex, int readLength, byte[] reference, int referenceStartIndex, int spanToTest) {
        if (spanToTest < 1 || spanToTest > this.maxBasesInOverhang || spanToTest > readLength / 2) {
            return false;
        }
        int numMismatchesSeen = 0;
        for (int i = 0; i < spanToTest; ++i) {
            if (read[readStartIndex + i] == reference[referenceStartIndex + i] || ++numMismatchesSeen <= this.maxMismatchesInOverhang) continue;
            return true;
        }
        return numMismatchesSeen >= (spanToTest + 1) / 2;
    }

    public void flush() {
        this.writeReads(0);
    }

    private void writeReads(int targetQueueSize) {
        while (this.getNReadsInQueue() > targetQueueSize) {
            List<SplitRead> waitingGroup = this.waitingReadGroups.poll();
            this.waitingReads -= waitingGroup.size();
            if (this.outputToFile) {
                SplitNCigarReads.repairSupplementaryTags(waitingGroup.stream().map(r -> r.read).collect(Collectors.toList()), this.header);
                for (SplitRead splitRead : waitingGroup) {
                    this.writer.addRead(splitRead.read);
                }
                continue;
            }
            if (waitingGroup.get((int)0).read.isSecondaryAlignment() || !waitingGroup.get(0).hasBeenOverhangClipped()) continue;
            waitingGroup.get(0).setMateChanged();
        }
    }

    public void activateWriting() {
        if (this.outputToFile) {
            throw new GATKException("Cannot activate writing for OverhangClippingManager multiple times");
        }
        this.flush();
        this.splices.clear();
        logger.info("Overhang Fixing Manager saved " + this.mateChangedReads.size() + " reads in the first pass");
        this.outputToFile = true;
    }

    @VisibleForTesting
    static String makeKey(String name, boolean firstOfPair, int mateStart) {
        return name + "@" + (firstOfPair ? 1 : 0) + "@" + mateStart;
    }

    public boolean setPredictedMateInformation(GATKRead read) {
        String keystring;
        if (!this.outputToFile) {
            return false;
        }
        if (!read.isEmpty() && read.isPaired() && this.mateChangedReads.containsKey(keystring = OverhangFixingManager.makeKey(read.getName(), read.isFirstOfPair(), read.getMateStart()))) {
            Tuple<Integer, String> value = this.mateChangedReads.get(keystring);
            read.setMatePosition(read.getMateContig(), (Integer)value.a);
            if (read.hasAttribute("MC")) {
                read.setAttribute("MC", (String)value.b);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    SplitRead getSplitRead(GATKRead read) {
        return new SplitRead(read);
    }

    private final class SpliceComparator
    implements Comparator<Splice>,
    Serializable {
        private static final long serialVersionUID = -7783679773557594065L;

        private SpliceComparator() {
        }

        @Override
        public int compare(Splice position1, Splice position2) {
            return position1.loc.compareTo(position2.loc);
        }
    }

    protected final class Splice {
        public final GenomeLoc loc;
        public byte[] reference;

        public Splice(String contig, int start, int end) {
            this.loc = OverhangFixingManager.this.genomeLocParser.createGenomeLoc(contig, start, end);
        }

        public void initialize(ReferenceSequenceFile referenceReader) {
            this.reference = referenceReader.getSubsequenceAt(this.loc.getContig(), (long)this.loc.getStart(), (long)this.loc.getStop()).getBases();
        }

        public boolean equals(Object other) {
            return other != null && other instanceof Splice && this.loc.equals(((Splice)other).loc);
        }

        public int hashCode() {
            return this.loc.hashCode();
        }
    }

    private final class SplitReadComparator
    implements Comparator<List<SplitRead>>,
    Serializable {
        private static final long serialVersionUID = 7956407034441782842L;
        private final ReadCoordinateComparator readComparator;

        public SplitReadComparator() {
            this.readComparator = new ReadCoordinateComparator(OverhangFixingManager.this.header);
        }

        @Override
        public int compare(List<SplitRead> readgroup1, List<SplitRead> readgroup2) {
            return this.readComparator.compare(readgroup1.get((int)0).read, readgroup2.get((int)0).read);
        }
    }

    public final class SplitRead {
        private final Cigar oldCigar;
        private final int oldStart;
        public GATKRead read;
        public GenomeLoc unclippedLoc;

        public SplitRead(GATKRead read) {
            this.oldCigar = read.getCigar();
            this.oldStart = read.getStart();
            this.setRead(read);
        }

        public void setRead(GATKRead read) {
            this.read = read;
            int softStart = read.getSoftStart();
            int softEnd = read.getSoftEnd();
            if (!read.isUnmapped() && softStart < softEnd) {
                this.unclippedLoc = OverhangFixingManager.this.genomeLocParser.createGenomeLoc(read.getContig(), softStart, softEnd);
            }
        }

        public boolean hasBeenOverhangClipped() {
            return !this.oldCigar.equals((Object)this.read.getCigar()) || this.oldStart != this.read.getStart();
        }

        public void setMateChanged() {
            if (!this.read.isUnmapped()) {
                OverhangFixingManager.this.mateChangedReads.put(OverhangFixingManager.makeKey(this.read.getName(), !this.read.isFirstOfPair(), this.oldStart), new Tuple((Object)this.read.getStart(), (Object)TextCigarCodec.encode((Cigar)this.read.getCigar())));
            }
        }
    }
}

