/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.rnaseq;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.TextCigarCodec;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.MultiplePassReadWalker;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.rnaseq.OverhangFixingManager;
import org.broadinstitute.hellbender.transformers.MappingQualityReadTransformer;
import org.broadinstitute.hellbender.transformers.NDNCigarReadTransformer;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.GenomeLocParser;
import org.broadinstitute.hellbender.utils.SATagBuilder;
import org.broadinstitute.hellbender.utils.clipping.ReadClipper;
import org.broadinstitute.hellbender.utils.fasta.CachingIndexedFastaSequenceFile;
import org.broadinstitute.hellbender.utils.read.ArtificialReadUtils;
import org.broadinstitute.hellbender.utils.read.CigarUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMFileGATKReadWriter;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Splits reads that contain Ns in their cigar string (e.g. spanning splicing events).", oneLineSummary="Split Reads with N in Cigar", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
@WorkflowProperties
public final class SplitNCigarReads
extends MultiplePassReadWalker {
    static final String[] TAGS_TO_REMOVE = new String[]{"NM", "MD", "NH"};
    static final String MATE_CIGAR_TAG = "MC";
    @Argument(fullName="output", shortName="O", doc="Write output to this BAM filename")
    @WorkflowOutput(optionalCompanions={"outputIndex"})
    GATKPath OUTPUT;
    @Argument(fullName="refactor-cigar-string", shortName="fixNDN", doc="refactor cigar string with NDN elements to one element", optional=true)
    boolean REFACTOR_NDN_CIGAR_READS = false;
    @Argument(fullName="skip-mapping-quality-transform", shortName="skip-mq-transform", doc="skip the 255 -> 60 MQ read transform", optional=true)
    boolean SKIP_MQ_TRANSFORM = false;
    @Advanced
    @Argument(fullName="max-reads-in-memory", doc="max reads allowed to be kept in memory at a time by the BAM writer", optional=true)
    int MAX_RECORDS_IN_MEMORY = 150000;
    @Argument(fullName="max-mismatches-in-overhang", doc="max number of mismatches allowed in the overhang", optional=true)
    int MAX_MISMATCHES_IN_OVERHANG = 1;
    @Argument(fullName="max-bases-in-overhang", doc="max number of bases allowed in the overhang", optional=true)
    int MAX_BASES_TO_CLIP = 40;
    @Argument(fullName="do-not-fix-overhangs", doc="do not have the walker soft-clip overhanging sections of the reads", optional=true)
    boolean doNotFixOverhangs = false;
    @Argument(fullName="process-secondary-alignments", doc="have the walker split secondary alignments (will still repair MC tag without it)", optional=true)
    boolean processSecondaryAlignments = false;
    private SAMFileGATKReadWriter outputWriter;
    private OverhangFixingManager overhangManager;
    private ReferenceSequenceFile referenceReader;
    SAMFileHeader header;
    private static final int FROM_QUALITY = 255;
    private static final int TO_QUALITY = 60;

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Collections.singletonList(ReadFilterLibrary.ALLOW_ALL_READS);
    }

    @Override
    public ReadTransformer makePreReadFilterTransformer() {
        if (this.REFACTOR_NDN_CIGAR_READS) {
            return new NDNCigarReadTransformer();
        }
        return ReadTransformer.identity();
    }

    @Override
    public ReadTransformer makePostReadFilterTransformer() {
        if (this.SKIP_MQ_TRANSFORM) {
            return ReadTransformer.identity();
        }
        return new MappingQualityReadTransformer(255, 60);
    }

    @Override
    public void onTraversalStart() {
        this.header = this.getHeaderForSAMWriter();
        this.referenceReader = new CachingIndexedFastaSequenceFile(this.referenceArguments.getReferencePath());
        GenomeLocParser genomeLocParser = new GenomeLocParser(this.getBestAvailableSequenceDictionary());
        this.outputWriter = this.createSAMWriter(this.OUTPUT, false);
        this.overhangManager = new OverhangFixingManager(this.header, this.outputWriter, genomeLocParser, this.referenceReader, this.MAX_RECORDS_IN_MEMORY, this.MAX_MISMATCHES_IN_OVERHANG, this.MAX_BASES_TO_CLIP, this.doNotFixOverhangs, this.processSecondaryAlignments);
    }

    @Override
    public void traverseReads() {
        this.forEachRead((read, reference, features) -> SplitNCigarReads.splitNCigarRead(read, this.overhangManager, true, this.header, this.processSecondaryAlignments));
        this.overhangManager.activateWriting();
        this.forEachRead((read, reference, features) -> SplitNCigarReads.splitNCigarRead(read, this.overhangManager, true, this.header, this.processSecondaryAlignments));
    }

    @Override
    public void closeTool() {
        if (this.overhangManager != null) {
            this.overhangManager.flush();
        }
        if (this.outputWriter != null) {
            this.outputWriter.close();
        }
        try {
            if (this.referenceReader != null) {
                this.referenceReader.close();
            }
        }
        catch (IOException ex) {
            throw new UserException.MissingReference("Could not find reference file.", true);
        }
    }

    public static GATKRead splitNCigarRead(GATKRead read, OverhangFixingManager manager, boolean emitReads, SAMFileHeader header, boolean secondaryAlignments) {
        int numCigarElements = read.numCigarElements();
        ArrayList<GATKRead> splitReads = new ArrayList<GATKRead>(2);
        if (emitReads && read.hasAttribute(MATE_CIGAR_TAG)) {
            GATKRead mateSplitting = SplitNCigarReads.splitNCigarRead(ArtificialReadUtils.createArtificialRead(header, TextCigarCodec.decode((String)read.getAttributeAsString(MATE_CIGAR_TAG))), manager, false, header, secondaryAlignments);
            read.setAttribute(MATE_CIGAR_TAG, mateSplitting.getCigar().toString());
        }
        manager.setPredictedMateInformation(read);
        if (!secondaryAlignments && read.isSecondaryAlignment()) {
            manager.addReadGroup(Collections.singletonList(read));
            return read;
        }
        boolean sectionHasMatch = false;
        int firstCigarIndex = 0;
        for (int i = 0; i < numCigarElements; ++i) {
            CigarElement cigarElement = read.getCigarElement(i);
            CigarOperator op = cigarElement.getOperator();
            if (op == CigarOperator.M || op == CigarOperator.EQ || op == CigarOperator.X || op == CigarOperator.I || op == CigarOperator.D) {
                sectionHasMatch = true;
            }
            if (op != CigarOperator.N) continue;
            if (sectionHasMatch) {
                if (!emitReads) {
                    splitReads.add(SplitNCigarReads.splitReadBasedOnCigar(read, firstCigarIndex, i, null));
                } else {
                    splitReads.add(SplitNCigarReads.splitReadBasedOnCigar(read, firstCigarIndex, i, manager));
                }
            }
            firstCigarIndex = i + 1;
            sectionHasMatch = false;
        }
        if (splitReads.size() < 1) {
            if (emitReads) {
                manager.addReadGroup(Collections.singletonList(read));
            }
            return read;
        }
        if (firstCigarIndex < numCigarElements && sectionHasMatch) {
            splitReads.add(SplitNCigarReads.splitReadBasedOnCigar(read, firstCigarIndex, numCigarElements, null));
        }
        if (emitReads) {
            manager.addReadGroup(splitReads);
            return read;
        }
        return (GATKRead)splitReads.get(0);
    }

    private static GATKRead splitReadBasedOnCigar(GATKRead read, int cigarStartIndex, int cigarEndIndex, OverhangFixingManager forSplitPositions) {
        int cigarFirstIndex = cigarStartIndex;
        int cigarSecondIndex = cigarEndIndex;
        while (read.getCigarElement(cigarFirstIndex).getOperator().equals((Object)CigarOperator.D)) {
            ++cigarFirstIndex;
        }
        while (read.getCigarElement(cigarSecondIndex - 1).getOperator().equals((Object)CigarOperator.D)) {
            --cigarSecondIndex;
        }
        if (cigarFirstIndex > cigarSecondIndex) {
            throw new IllegalArgumentException("Cannot split this read (might be an empty section between Ns, for example 1N1D1N): " + read.getCigar().toString());
        }
        List<CigarElement> elements = read.getCigarElements();
        int startRefIndex = read.getUnclippedStart() + CigarUtils.countRefBasesAndClips(elements, 0, cigarFirstIndex);
        int stopRefIndex = startRefIndex + CigarUtils.countRefBasesAndClips(elements, cigarFirstIndex, cigarSecondIndex) - 1;
        if (forSplitPositions != null) {
            String contig = read.getContig();
            int splitStart = startRefIndex + CigarUtils.countRefBasesAndClips(elements, cigarFirstIndex, cigarEndIndex);
            int splitEnd = splitStart + read.getCigarElement(cigarEndIndex).getLength() - 1;
            forSplitPositions.addSplicePosition(contig, splitStart, splitEnd);
        }
        return ReadClipper.softClipToRegionIncludingClippedBases(read, startRefIndex, stopRefIndex);
    }

    public static void repairSupplementaryTags(List<GATKRead> readFamily, SAMFileHeader header) {
        for (GATKRead read : readFamily) {
            for (String attribute : TAGS_TO_REMOVE) {
                read.clearAttribute(attribute);
            }
        }
        if (readFamily.size() > 1) {
            GATKRead primary = readFamily.remove(0);
            SATagBuilder.setReadsAsSupplemental(primary, readFamily);
        }
    }
}

