/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.sv;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Predicate;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.programgroups.StructuralVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.tools.sv.DiscordantPairEvidence;
import org.broadinstitute.hellbender.tools.sv.SplitReadEvidence;
import org.broadinstitute.hellbender.utils.codecs.DiscordantPairEvidenceCodec;
import org.broadinstitute.hellbender.utils.codecs.SplitReadEvidenceCodec;
import org.broadinstitute.hellbender.utils.io.FeatureOutputStream;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@BetaFeature
@CommandLineProgramProperties(summary="Gathers paired-end and split read evidence files for use in the GATK-SV pipeline. Output files are a file containing the location of and orientation of read pairs marked as discordant, and a file containing the clipping location of all soft clipped reads and the orientation of the clipping.", oneLineSummary="Gathers paired-end and split read evidence files for use in the GATK-SV pipeline.", programGroup=StructuralVariantDiscoveryProgramGroup.class)
public class PairedEndAndSplitReadEvidenceCollection
extends ReadWalker {
    public static final String PAIRED_END_FILE_ARGUMENT_SHORT_NAME = "PE";
    public static final String PAIRED_END_FILE_ARGUMENT_LONG_NAME = "pe-file";
    public static final String SPLIT_READ_FILE_ARGUMENT_SHORT_NAME = "SR";
    public static final String SPLIT_READ_FILE_ARGUMENT_LONG_NAME = "sr-file";
    public static final String SAMPLE_NAME_ARGUMENT_LONG_NAME = "sample-name";
    public static final String COMPRESSION_LEVEL_ARGUMENT_LONG_NAME = "compression-level";
    @Argument(shortName="PE", fullName="pe-file", doc="Output file for paired end evidence", optional=false)
    public GATKPath peFile;
    @Argument(shortName="SR", fullName="sr-file", doc="Output file for split read evidence", optional=false)
    public GATKPath srFile;
    @Argument(fullName="sample-name", doc="Sample name")
    String sampleName = null;
    @Argument(fullName="compression-level", doc="Output compression level")
    int compressionLevel = 4;
    final Set<String> observedDiscordantNames = new HashSet<String>();
    final PriorityQueue<SplitPos> splitPosBuffer = new PriorityQueue<SplitPos>(new SplitPosComparator());
    final List<DiscordantRead> discordantPairs = new ArrayList<DiscordantRead>();
    int currentDiscordantPosition = -1;
    String currentChrom = null;
    private FeatureOutputStream<DiscordantPairEvidence> peWriter;
    private FeatureOutputStream<SplitReadEvidence> srWriter;
    private SAMSequenceDictionary sequenceDictionary;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public void onTraversalStart() {
        super.onTraversalStart();
        this.sequenceDictionary = this.getBestAvailableSequenceDictionary();
        this.peWriter = new FeatureOutputStream<DiscordantPairEvidence>(this.peFile, (FeatureCodec<Feature, ?>)new DiscordantPairEvidenceCodec(), DiscordantPairEvidenceCodec::encode, this.sequenceDictionary, this.compressionLevel);
        this.srWriter = new FeatureOutputStream<SplitReadEvidence>(this.srFile, (FeatureCodec<Feature, ?>)new SplitReadEvidenceCodec(), SplitReadEvidenceCodec::encode, this.sequenceDictionary, this.compressionLevel);
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        ArrayList<ReadFilter> readFilters = new ArrayList<ReadFilter>(super.getDefaultReadFilters());
        readFilters.add(ReadFilterLibrary.MATE_UNMAPPED_AND_UNMAPPED_READ_FILTER);
        readFilters.add(ReadFilterLibrary.NOT_DUPLICATE);
        readFilters.add(ReadFilterLibrary.NOT_SECONDARY_ALIGNMENT);
        readFilters.add(ReadFilterLibrary.NOT_SUPPLEMENTARY_ALIGNMENT);
        return readFilters;
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        if (this.isSoftClipped(read)) {
            this.countSplitRead(read, this.splitPosBuffer, this.srWriter);
        }
        if (!read.isProperlyPaired()) {
            this.reportDiscordantReadPair(read);
        }
    }

    private void reportDiscordantReadPair(GATKRead read) {
        DiscordantRead reportableDiscordantReadPair;
        if (read.getStart() != this.currentDiscordantPosition) {
            this.flushDiscordantReadPairs();
            this.currentDiscordantPosition = read.getStart();
            this.observedDiscordantNames.clear();
        }
        if ((reportableDiscordantReadPair = this.getReportableDiscordantReadPair(read, this.observedDiscordantNames, this.sequenceDictionary)) != null) {
            this.discordantPairs.add(reportableDiscordantReadPair);
        }
    }

    @VisibleForTesting
    public DiscordantRead getReportableDiscordantReadPair(GATKRead read, Set<String> observedDiscordantNamesAtThisLocus, SAMSequenceDictionary samSequenceDictionary) {
        int mateSeqId;
        int readSeqId = samSequenceDictionary.getSequenceIndex(read.getContig());
        if (readSeqId < (mateSeqId = samSequenceDictionary.getSequenceIndex(read.getMateContig()))) {
            return new DiscordantRead(read);
        }
        if (readSeqId == mateSeqId) {
            boolean seenBefore;
            if (read.getStart() < read.getMateStart()) {
                return new DiscordantRead(read);
            }
            if (read.getStart() == read.getMateStart() && !(seenBefore = observedDiscordantNamesAtThisLocus.remove(read.getName()))) {
                DiscordantRead discordantRead = new DiscordantRead(read);
                observedDiscordantNamesAtThisLocus.add(read.getName());
                return discordantRead;
            }
        }
        return null;
    }

    private void flushDiscordantReadPairs() {
        DiscordantReadComparator discReadComparator = new DiscordantReadComparator(this.sequenceDictionary);
        this.discordantPairs.sort(discReadComparator);
        this.discordantPairs.forEach(this::writeDiscordantPair);
        this.discordantPairs.clear();
    }

    private void writeDiscordantPair(DiscordantRead r) {
        boolean strandA = !r.isReadReverseStrand();
        boolean strandB = !r.isMateReverseStrand();
        DiscordantPairEvidence discordantPair = new DiscordantPairEvidence(this.sampleName, r.getContig(), r.getStart(), strandA, r.getMateContig(), r.getMateStart(), strandB);
        this.peWriter.add(discordantPair);
    }

    @VisibleForTesting
    public void countSplitRead(GATKRead read, PriorityQueue<SplitPos> splitCounts, FeatureOutputStream<SplitReadEvidence> srWriter) {
        SplitPos splitPosition = this.getSplitPosition(read);
        int readStart = read.getStart();
        if (splitPosition.direction == POSITION.MIDDLE) {
            return;
        }
        if (this.currentChrom == null) {
            this.currentChrom = read.getContig();
        } else if (!this.currentChrom.equals(read.getContig())) {
            this.flushSplitCounts(splitPos -> true, srWriter, splitCounts);
            this.currentChrom = read.getContig();
        } else {
            this.flushSplitCounts(sp -> sp.pos < readStart - 1, srWriter, splitCounts);
        }
        splitCounts.add(splitPosition);
    }

    private void flushSplitCounts(Predicate<SplitPos> flushablePosition, FeatureOutputStream<SplitReadEvidence> srWriter, PriorityQueue<SplitPos> splitCounts) {
        while (splitCounts.size() > 0 && flushablePosition.test(splitCounts.peek())) {
            SplitPos pos = splitCounts.poll();
            int countAtPos = 1;
            while (splitCounts.size() > 0 && splitCounts.peek().equals(pos)) {
                ++countAtPos;
                splitCounts.poll();
            }
            SplitReadEvidence splitRead = new SplitReadEvidence(this.sampleName, this.currentChrom, pos.pos, countAtPos, pos.direction.equals((Object)POSITION.RIGHT));
            srWriter.add(splitRead);
        }
    }

    private SplitPos getSplitPosition(GATKRead read) {
        if (read.getCigar().getFirstCigarElement().getOperator() == CigarOperator.M) {
            int matchLength = read.getCigar().getCigarElements().stream().filter(e -> e.getOperator().consumesReferenceBases()).mapToInt(CigarElement::getLength).sum();
            return new SplitPos(read.getStart() + matchLength, POSITION.RIGHT);
        }
        if (read.getCigar().getLastCigarElement().getOperator() == CigarOperator.M) {
            return new SplitPos(read.getStart(), POSITION.LEFT);
        }
        return new SplitPos(-1, POSITION.MIDDLE);
    }

    private boolean isSoftClipped(GATKRead read) {
        CigarOperator firstOperator = read.getCigar().getFirstCigarElement().getOperator();
        CigarOperator lastOperator = read.getCigar().getLastCigarElement().getOperator();
        return firstOperator == CigarOperator.SOFT_CLIP && lastOperator != CigarOperator.SOFT_CLIP || firstOperator != CigarOperator.SOFT_CLIP && lastOperator == CigarOperator.SOFT_CLIP;
    }

    @Override
    public Object onTraversalSuccess() {
        this.flushSplitCounts(splitPos -> true, this.srWriter, this.splitPosBuffer);
        this.flushDiscordantReadPairs();
        return null;
    }

    @Override
    public void closeTool() {
        super.closeTool();
        if (this.peWriter != null) {
            this.peWriter.close();
        }
        if (this.srWriter != null) {
            this.srWriter.close();
        }
    }

    @VisibleForTesting
    static final class DiscordantReadComparator
    implements Comparator<DiscordantRead> {
        private final Comparator<DiscordantRead> internalComparator = Comparator.comparing(r -> sequenceDictionary.getSequenceIndex(r.getContig())).thenComparing(DiscordantRead::getStart).thenComparing(DiscordantRead::isReadReverseStrand).thenComparing((? super T r) -> sequenceDictionary.getSequenceIndex(r.getMateContig())).thenComparing(DiscordantRead::getMateStart).thenComparing(DiscordantRead::isMateReverseStrand);

        public DiscordantReadComparator(SAMSequenceDictionary sequenceDictionary) {
        }

        @Override
        public int compare(DiscordantRead o1, DiscordantRead o2) {
            return this.internalComparator.compare(o1, o2);
        }
    }

    @VisibleForTesting
    static final class SplitPosComparator
    implements Comparator<SplitPos> {
        SplitPosComparator() {
        }

        @Override
        public int compare(SplitPos o1, SplitPos o2) {
            if (o1.pos != o2.pos) {
                return Integer.compare(o1.pos, o2.pos);
            }
            return o1.direction.compareTo(o2.direction);
        }
    }

    @VisibleForTesting
    static final class SplitPos {
        public POSITION direction;
        public int pos;

        public SplitPos(int start, POSITION direction) {
            this.pos = start;
            this.direction = direction;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SplitPos splitPos = (SplitPos)o;
            if (this.pos != splitPos.pos) {
                return false;
            }
            return this.direction.ordinal() == splitPos.direction.ordinal();
        }

        public int hashCode() {
            int result = this.direction != null ? this.direction.ordinal() : 0;
            result = 31 * result + this.pos;
            return result;
        }
    }

    @VisibleForTesting
    static final class DiscordantRead {
        private boolean readReverseStrand;
        private boolean mateReverseStrand;
        private String contig;
        private int start;
        private String mateContig;
        private int mateStart;
        private String name;

        public DiscordantRead(GATKRead read) {
            this.readReverseStrand = read.isReverseStrand();
            this.mateReverseStrand = read.mateIsReverseStrand();
            this.contig = read.getContig();
            this.start = read.getStart();
            this.mateContig = read.getMateContig();
            this.mateStart = read.getMateStart();
            this.name = read.getName();
        }

        public boolean isReadReverseStrand() {
            return this.readReverseStrand;
        }

        public void setReadReverseStrand(boolean readReverseStrand) {
            this.readReverseStrand = readReverseStrand;
        }

        public boolean isMateReverseStrand() {
            return this.mateReverseStrand;
        }

        public void setMateReverseStrand(boolean mateReverseStrand) {
            this.mateReverseStrand = mateReverseStrand;
        }

        public String getContig() {
            return this.contig;
        }

        public void setContig(String contig) {
            this.contig = contig;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public String getMateContig() {
            return this.mateContig;
        }

        public void setMateContig(String mateContig) {
            this.mateContig = mateContig;
        }

        public int getMateStart() {
            return this.mateStart;
        }

        public void setMateStart(int mateStart) {
            this.mateStart = mateStart;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiscordantRead that = (DiscordantRead)o;
            if (this.readReverseStrand != that.readReverseStrand) {
                return false;
            }
            if (this.mateReverseStrand != that.mateReverseStrand) {
                return false;
            }
            if (this.start != that.start) {
                return false;
            }
            if (this.mateStart != that.mateStart) {
                return false;
            }
            if (this.contig != null ? !this.contig.equals(that.contig) : that.contig != null) {
                return false;
            }
            if (this.mateContig != null ? !this.mateContig.equals(that.mateContig) : that.mateContig != null) {
                return false;
            }
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        public int hashCode() {
            int result = this.readReverseStrand ? 1 : 0;
            result = 31 * result + (this.mateReverseStrand ? 1 : 0);
            result = 31 * result + (this.contig != null ? this.contig.hashCode() : 0);
            result = 31 * result + this.start;
            result = 31 * result + (this.mateContig != null ? this.mateContig.hashCode() : 0);
            result = 31 * result + this.mateStart;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }

    static enum POSITION {
        LEFT("left"),
        MIDDLE("middle"),
        RIGHT("right");

        private String description;

        private POSITION(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

