/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation;

import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.HashSet;
import org.apache.commons.lang.mutable.MutableInt;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="Annotate a vcf with a bam's read depth at each variant locus", oneLineSummary="(Internal) Annotate a vcf with a bam's read depth at each variant locus", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
public class AnnotateVcfWithBamDepth
extends VariantWalker {
    @Argument(fullName="output", shortName="O", doc="The output filtered VCF file", optional=false)
    private final GATKPath outputVcf = null;
    private VariantContextWriter vcfWriter;
    public static final String POOLED_BAM_DEPTH_ANNOTATION_NAME = "BAM_DEPTH";

    @Override
    public void onTraversalStart() {
        VCFHeader inputHeader = this.getHeaderForVariants();
        HashSet<Object> headerLines = new HashSet<Object>(inputHeader.getMetaDataInSortedOrder());
        headerLines.add(new VCFInfoHeaderLine(POOLED_BAM_DEPTH_ANNOTATION_NAME, 1, VCFHeaderLineType.Integer, "pooled bam depth"));
        headerLines.addAll(this.getDefaultToolVCFHeaderLines());
        VCFHeader vcfHeader = new VCFHeader(headerLines, inputHeader.getGenotypeSamples());
        this.vcfWriter = this.createVCFWriter(this.outputVcf);
        this.vcfWriter.writeHeader(vcfHeader);
    }

    @Override
    public void apply(VariantContext vc, ReadsContext readsContext, ReferenceContext refContext, FeatureContext fc) {
        MutableInt depth = new MutableInt(0);
        for (GATKRead read : readsContext) {
            if (read.failsVendorQualityCheck() || read.isDuplicate() || read.isUnmapped() || read.getEnd() <= read.getStart() || !new SimpleInterval(read).contains((Locatable)vc)) continue;
            depth.increment();
        }
        this.vcfWriter.add(new VariantContextBuilder(vc).attribute(POOLED_BAM_DEPTH_ANNOTATION_NAME, (Object)depth.intValue()).make());
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }
}

