/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.MathArrays;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.tools.walkers.validation.MixingFraction;
import org.broadinstitute.hellbender.utils.MathUtils;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="Annotate a multi-sample vcf with expected allele fractions in pooled sequencing given mixing fractions of the different samples in the pool via the formula Expected allele fraction = SUM_samples {mixing_fraction(sample) * [0 if hom ref, 0.5 is het, 1.0 if hom var]}", oneLineSummary="(Internal) Annotate a vcf with expected allele fractions in pooled sequencing", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
public class AnnotateVcfWithExpectedAlleleFraction
extends VariantWalker {
    public static final String MIXING_FRACTIONS_TABLE_NAME = "mixing-fractions";
    @Argument(fullName="output", shortName="O", doc="The output annotated VCF file", optional=false)
    private final GATKPath outputVcf = null;
    @Argument(fullName="mixing-fractions", shortName="mixing-fractions", doc="The input mixing fractions table", optional=false)
    private final File inputMixingFractions = null;
    private VariantContextWriter vcfWriter;
    public static final String EXPECTED_ALLELE_FRACTION_NAME = "AF_EXP";
    double[] mixingFractionsInSampleOrder;

    @Override
    public void onTraversalStart() {
        VCFHeader inputHeader = this.getHeaderForVariants();
        HashSet<Object> headerLines = new HashSet<Object>(inputHeader.getMetaDataInSortedOrder());
        headerLines.add(new VCFInfoHeaderLine(EXPECTED_ALLELE_FRACTION_NAME, 1, VCFHeaderLineType.Float, "expected allele fraction in pooled bam"));
        VCFHeader vcfHeader = new VCFHeader(headerLines, inputHeader.getGenotypeSamples());
        headerLines.addAll(this.getDefaultToolVCFHeaderLines());
        this.vcfWriter = this.createVCFWriter(this.outputVcf);
        this.vcfWriter.writeHeader(vcfHeader);
        List<MixingFraction> mixingFractionsList = MixingFraction.readMixingFractions(this.inputMixingFractions);
        Map<String, Double> mixingfractionsMap = mixingFractionsList.stream().collect(Collectors.toMap(MixingFraction::getSample, MixingFraction::getMixingFraction));
        this.mixingFractionsInSampleOrder = inputHeader.getSampleNamesInOrder().stream().mapToDouble(mixingfractionsMap::get).toArray();
    }

    @Override
    public void apply(VariantContext vc, ReadsContext readsContext, ReferenceContext refContext, FeatureContext fc) {
        double[] weights = vc.getGenotypes().stream().mapToDouble(g -> AnnotateVcfWithExpectedAlleleFraction.weight(g)).toArray();
        double expectedAlleleFraction = MathUtils.sum(MathArrays.ebeMultiply((double[])weights, (double[])this.mixingFractionsInSampleOrder));
        this.vcfWriter.add(new VariantContextBuilder(vc).attribute(EXPECTED_ALLELE_FRACTION_NAME, (Object)expectedAlleleFraction).make());
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }

    private static double weight(Genotype genotype) {
        if (genotype.isHomVar()) {
            return 1.0;
        }
        if (genotype.isHet()) {
            return 0.5;
        }
        return 0.0;
    }
}

