/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation;

import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.mutable.MutableLong;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.tools.walkers.validation.MixingFraction;
import org.broadinstitute.hellbender.utils.locusiterator.AlignmentStateMachine;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.variant.VariantContextGetters;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="Calculate proportions of different samples in a pooled bam by first estimating each sample's mixing fraction as the average alt fraction in the bam of singleton hets belonging to that sample, then normalizing these initial estimates to sum to one.", oneLineSummary="(Internal) Calculate proportions of different samples in a pooled bam", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
public class CalculateMixingFractions
extends VariantWalker {
    @Argument(fullName="output", shortName="O", doc="The output table of samplemixing fractions", optional=false)
    private final File outputFile = null;
    private final Map<String, AltAndTotalReadCounts> sampleCounts = new HashMap<String, AltAndTotalReadCounts>();

    @Override
    public void onTraversalStart() {
        this.getHeaderForVariants().getGenotypeSamples().forEach(s -> this.sampleCounts.put((String)s, new AltAndTotalReadCounts()));
    }

    @Override
    public void apply(VariantContext vc, ReadsContext readsContext, ReferenceContext refContext, FeatureContext fc) {
        if (!this.isBiallelicSingletonHetSnp(vc)) {
            return;
        }
        Optional<String> variantSample = StreamSupport.stream(vc.getGenotypes().spliterator(), false).filter(genotype -> genotype.isHet()).map(genotype -> genotype.getSampleName()).findFirst();
        if (!variantSample.isPresent()) {
            return;
        }
        ArrayList<GATKRead> reads = new ArrayList<GATKRead>();
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        for (GATKRead read : readsContext) {
            if (read.failsVendorQualityCheck()) continue;
            AlignmentStateMachine asm = new AlignmentStateMachine(read);
            while (asm.stepForwardOnGenome() != null && asm.getGenomePosition() < vc.getStart()) {
            }
            if (asm.getGenomePosition() != vc.getStart()) continue;
            reads.add(read);
            offsets.add(asm.getReadOffset());
        }
        ReadPileup pileup = new ReadPileup((Locatable)vc, reads, offsets);
        byte altBase = vc.getAlternateAllele(0).getBases()[0];
        long altCount = StreamSupport.stream(pileup.spliterator(), false).filter(pe -> pe.getBase() == altBase).count();
        long totalCount = pileup.size();
        this.sampleCounts.get(variantSample.get()).addCounts(altCount, totalCount);
    }

    @Override
    public Object onTraversalSuccess() {
        double mixingFractionNormalizer = this.sampleCounts.values().stream().mapToDouble(AltAndTotalReadCounts::getAltFraction).sum();
        List<MixingFraction> mixingFractions = this.sampleCounts.entrySet().stream().map(e -> new MixingFraction((String)e.getKey(), ((AltAndTotalReadCounts)e.getValue()).getAltFraction() / mixingFractionNormalizer)).collect(Collectors.toList());
        MixingFraction.writeMixingFractions(mixingFractions, this.outputFile);
        return "SUCCESS";
    }

    private boolean isBiallelicSingletonHetSnp(VariantContext vc) {
        return vc.isBiallelic() && vc.isSNP() && (vc.hasAttribute("AC") && CalculateMixingFractions.getArrayAttribute(vc, "AC")[0] == 1.0 || vc.getGenotypes().stream().filter(genotype -> genotype.isHet()).count() == 1L);
    }

    private static double[] getArrayAttribute(VariantContext vc, String attribute) {
        return VariantContextGetters.getAttributeAsDoubleArray(vc, attribute, () -> null, -1.0);
    }

    private class AltAndTotalReadCounts {
        private final MutableLong altCount = new MutableLong(0L);
        private final MutableLong totalCount = new MutableLong(0L);

        private AltAndTotalReadCounts() {
        }

        public void addCounts(long numAlts, long numTotal) {
            this.altCount.add(numAlts);
            this.totalCount.add(numTotal);
        }

        public double getAltFraction() {
            return this.altCount.doubleValue() / this.totalCount.doubleValue();
        }
    }
}

