/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.validation;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFSimpleHeaderLine;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang.mutable.MutableLong;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.AbstractConcordanceWalker;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.validation.ConcordanceState;
import org.broadinstitute.hellbender.tools.walkers.validation.ConcordanceSummaryRecord;
import org.broadinstitute.hellbender.tools.walkers.validation.FilterAnalysisRecord;
import org.broadinstitute.hellbender.utils.Utils;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@CommandLineProgramProperties(summary="This tool evaluates an input VCF against a VCF that has been validated and is considered to represent ground truth.\n The summary statistics (# true positives, # false positives, # false negatives, sensitivity, precision) are reported \n in a TSV file (--summary). Note that this tool assumes that the truth VCF only contains PASS variants.", oneLineSummary="Evaluate concordance of an input VCF against a validated truth VCF", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
public class Concordance
extends AbstractConcordanceWalker {
    static final String USAGE_ONE_LINE_SUMMARY = "Evaluate concordance of an input VCF against a validated truth VCF";
    static final String USAGE_SUMMARY = "This tool evaluates an input VCF against a VCF that has been validated and is considered to represent ground truth.\n The summary statistics (# true positives, # false positives, # false negatives, sensitivity, precision) are reported \n in a TSV file (--summary). Note that this tool assumes that the truth VCF only contains PASS variants.";
    public static final String SUMMARY_LONG_NAME = "summary";
    public static final String SUMMARY_SHORT_NAME = "S";
    public static final String FILTER_ANALYSIS_LONG_NAME = "filter-analysis";
    public static final String TRUE_POSITIVES_AND_FALSE_NEGATIVES_LONG_NAME = "true-positives-and-false-negatives";
    public static final String TRUE_POSITIVES_AND_FALSE_NEGATIVES_SHORT_NAME = "tpfn";
    public static final String TRUE_POSITIVES_AND_FALSE_POSITIVES_LONG_NAME = "true-positives-and-false-positives";
    public static final String TRUE_POSITIVES_AND_FALSE_POSITIVES_SHORT_NAME = "tpfp";
    public static final String FILTERED_TRUE_NEGATIVES_AND_FALSE_NEGATIVES_LONG_NAME = "filtered-true-negatives-and-false-negatives";
    public static final String FILTERED_TRUE_NEGATIVES_AND_FALSE_NEGATIVES_SHORT_NAME = "ftnfn";
    public static final String TRUTH_STATUS_VCF_ATTRIBUTE = "STATUS";
    private static VCFInfoHeaderLine TRUTH_STATUS_HEADER_LINE = new VCFInfoHeaderLine("STATUS", 1, VCFHeaderLineType.String, "Truth status: TP/FP/FN for true positive/false positive/false negative.");
    @Argument(doc="A table of summary statistics (true positives, sensitivity, etc.)", fullName="summary", shortName="S")
    protected GATKPath summary;
    @Argument(doc="A table of the contribution of each filter to true and false negatives", fullName="filter-analysis", optional=true)
    protected GATKPath filterAnalysis;
    @Argument(doc="A vcf to write true positives and false negatives", fullName="true-positives-and-false-negatives", shortName="tpfn", optional=true)
    protected GATKPath truePositivesAndFalseNegativesVcf = null;
    @Argument(doc="A vcf to write true positives and false positives", fullName="true-positives-and-false-positives", shortName="tpfp", optional=true)
    protected GATKPath truePositivesAndFalsePositivesVcf = null;
    @Argument(doc="A vcf to write filtered true negatives and false negatives", fullName="filtered-true-negatives-and-false-negatives", shortName="ftnfn", optional=true)
    protected GATKPath filteredTrueNegativesAndFalseNegativesVcf = null;
    private final EnumMap<ConcordanceState, MutableLong> snpCounts = new EnumMap(ConcordanceState.class);
    private final EnumMap<ConcordanceState, MutableLong> indelCounts = new EnumMap(ConcordanceState.class);
    private VariantContextWriter truePositivesAndFalseNegativesVcfWriter;
    private VariantContextWriter truePositivesAndFalsePositivesVcfWriter;
    private VariantContextWriter filteredTrueNegativesAndFalseNegativesVcfWriter;
    private final Map<String, FilterAnalysisRecord> filterAnalysisRecords = new HashMap<String, FilterAnalysisRecord>();

    @Override
    public void onTraversalStart() {
        Set<VCFHeaderLine> defaultToolHeaderLines = this.getDefaultToolVCFHeaderLines();
        for (ConcordanceState state : ConcordanceState.values()) {
            this.snpCounts.put(state, new MutableLong(0L));
            this.indelCounts.put(state, new MutableLong(0L));
        }
        VCFHeader evalHeader = this.getEvalHeader();
        if (this.truePositivesAndFalseNegativesVcf != null) {
            this.truePositivesAndFalseNegativesVcfWriter = this.createVCFWriter(this.truePositivesAndFalseNegativesVcf);
            VCFHeader truthHeader = this.getTruthHeader();
            truthHeader.addMetaDataLine((VCFHeaderLine)TRUTH_STATUS_HEADER_LINE);
            defaultToolHeaderLines.forEach(arg_0 -> ((VCFHeader)truthHeader).addMetaDataLine(arg_0));
            this.truePositivesAndFalseNegativesVcfWriter.writeHeader(truthHeader);
        }
        if (this.truePositivesAndFalsePositivesVcf != null) {
            this.truePositivesAndFalsePositivesVcfWriter = this.createVCFWriter(this.truePositivesAndFalsePositivesVcf);
            defaultToolHeaderLines.forEach(arg_0 -> ((VCFHeader)evalHeader).addMetaDataLine(arg_0));
            evalHeader.addMetaDataLine((VCFHeaderLine)TRUTH_STATUS_HEADER_LINE);
            this.truePositivesAndFalsePositivesVcfWriter.writeHeader(evalHeader);
        }
        if (this.filteredTrueNegativesAndFalseNegativesVcf != null) {
            this.filteredTrueNegativesAndFalseNegativesVcfWriter = this.createVCFWriter(this.filteredTrueNegativesAndFalseNegativesVcf);
            evalHeader.addMetaDataLine((VCFHeaderLine)TRUTH_STATUS_HEADER_LINE);
            defaultToolHeaderLines.forEach(arg_0 -> ((VCFHeader)evalHeader).addMetaDataLine(arg_0));
            this.filteredTrueNegativesAndFalseNegativesVcfWriter.writeHeader(evalHeader);
        }
        List<String> filtersInVcf = evalHeader.getFilterLines().stream().map(VCFSimpleHeaderLine::getID).collect(Collectors.toList());
        filtersInVcf.forEach(filter -> this.filterAnalysisRecords.put((String)filter, new FilterAnalysisRecord((String)filter, 0, 0, 0, 0)));
    }

    @Override
    protected void apply(AbstractConcordanceWalker.TruthVersusEval truthVersusEval, ReadsContext readsContext, ReferenceContext refContext) {
        ConcordanceState concordanceState = truthVersusEval.getConcordance();
        if (truthVersusEval.getTruthIfPresentElseEval().isSNP()) {
            this.snpCounts.get((Object)concordanceState).increment();
        } else {
            this.indelCounts.get((Object)concordanceState).increment();
        }
        switch (concordanceState) {
            case TRUE_POSITIVE: {
                this.writeTruePositive(truthVersusEval);
                break;
            }
            case FALSE_POSITIVE: {
                this.writeFalsePositive(truthVersusEval);
                break;
            }
            case FALSE_NEGATIVE: {
                this.writeFalseNegative(truthVersusEval);
                break;
            }
            case FILTERED_TRUE_NEGATIVE: {
                this.writeFilteredTrueNegative(truthVersusEval);
                break;
            }
            case FILTERED_FALSE_NEGATIVE: {
                this.writeFilteredFalseNegative(truthVersusEval);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected ConcordanceState: " + concordanceState.toString());
            }
        }
        if (this.filterAnalysis != null && concordanceState == ConcordanceState.FILTERED_TRUE_NEGATIVE || concordanceState == ConcordanceState.FILTERED_FALSE_NEGATIVE) {
            Set filters = truthVersusEval.getEval().getFilters();
            boolean unique = filters.size() == 1;
            filters.stream().map(this.filterAnalysisRecords::get).forEach(record -> this.updateFilterAnalysisRecord((FilterAnalysisRecord)record, concordanceState, unique));
        }
    }

    private void updateFilterAnalysisRecord(FilterAnalysisRecord record, ConcordanceState state, boolean isOnlyFilter) {
        if (state == ConcordanceState.FILTERED_TRUE_NEGATIVE) {
            record.incrementTrueNegative();
            if (isOnlyFilter) {
                record.incrementUniqueTrueNegative();
            }
        } else if (state == ConcordanceState.FILTERED_FALSE_NEGATIVE) {
            record.incrementFalseNegative();
            if (isOnlyFilter) {
                record.incrementUniqueFalseNegative();
            }
        } else {
            throw new IllegalStateException("This method should only be called on a filtered ConcordanceState.");
        }
    }

    private void writeTruePositive(AbstractConcordanceWalker.TruthVersusEval truthVersusEval) {
        ConcordanceState state = truthVersusEval.getConcordance();
        Utils.validateArg(state == ConcordanceState.TRUE_POSITIVE, "This is not a true positive.");
        Concordance.tryToWrite(this.truePositivesAndFalseNegativesVcfWriter, this.annotateWithConcordanceState(truthVersusEval.getTruth(), state));
        Concordance.tryToWrite(this.truePositivesAndFalsePositivesVcfWriter, this.annotateWithConcordanceState(truthVersusEval.getEval(), state));
    }

    private void writeFalsePositive(AbstractConcordanceWalker.TruthVersusEval truthVersusEval) {
        ConcordanceState state = truthVersusEval.getConcordance();
        Utils.validateArg(state == ConcordanceState.FALSE_POSITIVE, "This is not a false positive.");
        Concordance.tryToWrite(this.truePositivesAndFalsePositivesVcfWriter, this.annotateWithConcordanceState(truthVersusEval.getEval(), state));
    }

    private void writeFalseNegative(AbstractConcordanceWalker.TruthVersusEval truthVersusEval) {
        ConcordanceState state = truthVersusEval.getConcordance();
        Utils.validateArg(state == ConcordanceState.FALSE_NEGATIVE, "This is not a false negative.");
        Concordance.tryToWrite(this.truePositivesAndFalseNegativesVcfWriter, this.annotateWithConcordanceState(truthVersusEval.getTruth(), state));
    }

    private void writeFilteredFalseNegative(AbstractConcordanceWalker.TruthVersusEval truthVersusEval) {
        ConcordanceState state = truthVersusEval.getConcordance();
        Utils.validateArg(state == ConcordanceState.FILTERED_FALSE_NEGATIVE, "This is not a filtered false negative.");
        Concordance.tryToWrite(this.truePositivesAndFalseNegativesVcfWriter, this.annotateWithConcordanceState(truthVersusEval.getTruth(), state));
        Concordance.tryToWrite(this.filteredTrueNegativesAndFalseNegativesVcfWriter, this.annotateWithConcordanceState(truthVersusEval.getEval(), state));
    }

    private void writeFilteredTrueNegative(AbstractConcordanceWalker.TruthVersusEval truthVersusEval) {
        ConcordanceState state = truthVersusEval.getConcordance();
        Utils.validateArg(state == ConcordanceState.FILTERED_TRUE_NEGATIVE, "This is not a filtered true negative.");
        Concordance.tryToWrite(this.filteredTrueNegativesAndFalseNegativesVcfWriter, this.annotateWithConcordanceState(truthVersusEval.getEval(), state));
    }

    private static void tryToWrite(VariantContextWriter writer, VariantContext vc) {
        if (writer != null) {
            writer.add(vc);
        }
    }

    @Override
    public Object onTraversalSuccess() {
        try (ConcordanceSummaryRecord.Writer concordanceSummaryWriter = ConcordanceSummaryRecord.getWriter(this.summary);){
            concordanceSummaryWriter.writeRecord(new ConcordanceSummaryRecord(VariantContext.Type.SNP, this.snpCounts.get((Object)ConcordanceState.TRUE_POSITIVE).longValue(), this.snpCounts.get((Object)ConcordanceState.FALSE_POSITIVE).longValue(), this.snpCounts.get((Object)ConcordanceState.FALSE_NEGATIVE).longValue() + this.snpCounts.get((Object)ConcordanceState.FILTERED_FALSE_NEGATIVE).longValue()));
            concordanceSummaryWriter.writeRecord(new ConcordanceSummaryRecord(VariantContext.Type.INDEL, this.indelCounts.get((Object)ConcordanceState.TRUE_POSITIVE).longValue(), this.indelCounts.get((Object)ConcordanceState.FALSE_POSITIVE).longValue(), this.indelCounts.get((Object)ConcordanceState.FALSE_NEGATIVE).longValue() + this.indelCounts.get((Object)ConcordanceState.FILTERED_FALSE_NEGATIVE).longValue()));
        }
        catch (IOException e) {
            throw new UserException("Encountered an IO exception writing the concordance summary table", e);
        }
        if (this.filterAnalysis != null) {
            FilterAnalysisRecord.writeToFile(this.filterAnalysisRecords.values(), this.filterAnalysis);
        }
        if (this.truePositivesAndFalsePositivesVcfWriter != null) {
            this.truePositivesAndFalsePositivesVcfWriter.close();
        }
        if (this.truePositivesAndFalseNegativesVcfWriter != null) {
            this.truePositivesAndFalseNegativesVcfWriter.close();
        }
        if (this.filteredTrueNegativesAndFalseNegativesVcfWriter != null) {
            this.filteredTrueNegativesAndFalseNegativesVcfWriter.close();
        }
        return "SUCCESS";
    }

    @Override
    protected boolean areVariantsAtSameLocusConcordant(VariantContext truth, VariantContext eval) {
        boolean sameRefAllele = truth.getReference().equals((Object)eval.getReference());
        boolean containsAltAllele = truth.getAlternateAlleles().size() == eval.getAlternateAlleles().size() && truth.getAlternateAlleles().size() > 0 && eval.getAlternateAlleles().contains(truth.getAlternateAllele(0));
        return sameRefAllele && containsAltAllele;
    }

    @Override
    protected Predicate<VariantContext> makeTruthVariantFilter() {
        return vc -> !vc.isFiltered() && !vc.isSymbolicOrSV();
    }

    private VariantContext annotateWithConcordanceState(VariantContext vc, ConcordanceState state) {
        return new VariantContextBuilder(vc).attribute(TRUTH_STATUS_VCF_ATTRIBUTE, (Object)state.getAbbreviation()).make();
    }
}

